<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';
checkLogin();

if(isset($_POST['add_command'])) {
    $content_id = (int)$_POST['content_id'];
    $reader_id = (int)$_POST['reader_id'];
    $command_phrase = clean($_POST['command_phrase']);
    $user_id = $_SESSION['user_id'];
    
    // التحقق من عدم وجود نفس الأمر للمحتوى والقارئ
    $check = $conn->query("SELECT id FROM content_readers 
                          WHERE content_id = $content_id 
                          AND reader_id = $reader_id 
                          AND status = 1");
    
    if($check->num_rows == 0) {
        $query = "INSERT INTO content_readers (content_id, reader_id, command_phrase, created_by) 
                  VALUES ($content_id, $reader_id, '$command_phrase', $user_id)";
        
        if($conn->query($query)) {
            setAlert('تم إضافة الأمر الصوتي بنجاح');
            header("Location: commands.php");
            exit();
        } else {
            setAlert('حدث خطأ أثناء إضافة الأمر الصوتي', 'danger');
        }
    } else {
        setAlert('يوجد أمر صوتي مسجل مسبقاً لهذا المحتوى والقارئ', 'danger');
    }
}

include 'includes/header.php';

// جلب المحتويات والقراء
$contents = $conn->query("SELECT c.*, ct.name as type_name 
                         FROM contents c 
                         JOIN content_types ct ON c.type_id = ct.id 
                         WHERE c.status = 1 
                         ORDER BY c.title ASC");
$readers = getReaders();
?>

<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">إضافة أمر صوتي جديد</h5>
                    <a href="commands.php" class="btn btn-light btn-sm">
                        <i class="fas fa-arrow-right me-1"></i> عودة
                    </a>
                </div>
                <div class="card-body">
                    <?php if($alert = getAlert()): ?>
                        <div class="alert alert-<?php echo $alert['type']; ?>">
                            <?php echo $alert['message']; ?>
                        </div>
                    <?php endif; ?>

                    <form method="POST" class="needs-validation" novalidate>
                        <div class="mb-3">
                            <label class="form-label">المحتوى</label>
                            <select name="content_id" class="form-select" required>
                                <option value="">اختر المحتوى</option>
                                <?php while($content = $contents->fetch_assoc()): ?>
                                <option value="<?php echo $content['id']; ?>">
                                    <?php echo $content['title']; ?> 
                                    (<?php echo $content['type_name']; ?>)
                                </option>
                                <?php endwhile; ?>
                            </select>
                            <div class="invalid-feedback">يرجى اختيار المحتوى</div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">القارئ</label>
                            <select name="reader_id" class="form-select" required>
                                <option value="">اختر القارئ</option>
                                <?php foreach($readers as $reader): ?>
                                <option value="<?php echo $reader['id']; ?>">
                                    <?php echo $reader['name']; ?>
                                </option>
                                <?php endforeach; ?>
                            </select>
                            <div class="invalid-feedback">يرجى اختيار القارئ</div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">الأمر الصوتي</label>
                            <input type="text" name="command_phrase" class="form-control" 
                                   placeholder="مثال: شغل دعاء كميل بصوت فلان" required>
                            <div class="form-text text-muted">
                                أدخل الأمر الصوتي كما سيتم نطقه للمساعد الصوتي
                            </div>
                            <div class="invalid-feedback">يرجى إدخال الأمر الصوتي</div>
                        </div>

                        <div class="text-end">
                            <a href="commands.php" class="btn btn-light">إلغاء</a>
                            <button type="submit" name="add_command" class="btn btn-primary">
                                إضافة الأمر الصوتي
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>