<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';
checkLogin();

if(isset($_POST['add_content'])) {
    $title = clean($_POST['title']);
    $description = clean($_POST['description']);
    $type_id = (int)$_POST['type_id'];
    $user_id = $_SESSION['user_id'];
    
    $query = "INSERT INTO contents (title, description, type_id, created_by) 
              VALUES ('$title', '$description', $type_id, $user_id)";
    
    if($conn->query($query)) {
        $content_id = $conn->insert_id;
        
        // إضافة الأوامر الصوتية للقراء
        if(isset($_POST['readers']) && is_array($_POST['readers'])) {
            foreach($_POST['readers'] as $reader_id) {
                $command = clean($_POST['command_'.$reader_id]);
                if(!empty($command)) {
                    $query = "INSERT INTO content_readers (content_id, reader_id, command_phrase, created_by) 
                             VALUES ($content_id, $reader_id, '$command', $user_id)";
                    $conn->query($query);
                }
            }
        }
        
        setAlert('تم إضافة المحتوى بنجاح');
        header("Location: contents.php");
        exit();
    } else {
        setAlert('حدث خطأ أثناء إضافة المحتوى', 'danger');
    }
}

// جلب أنواع المحتوى والقراء
$content_types = getContentTypes();
$readers = getReaders();

include 'includes/header.php';
?>

<div class="container-fluid">
    <!-- Page Title -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="h4 mb-0" style="color: var(--dark-blue);">إضافة محتوى جديد</h2>
        <a href="contents.php" class="btn" style="background: var(--orange); color: white;">
            <i class="fas fa-arrow-right me-1"></i>
            عودة للمحتويات
        </a>
    </div>

    <?php if($alert = getAlert()): ?>
        <div class="alert alert-<?php echo $alert['type']; ?> p-3 rounded-3">
            <?php echo $alert['message']; ?>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-lg-8">
            <!-- Content Information -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">معلومات المحتوى</h5>
                </div>
                <div class="card-body">
                    <form method="POST" class="needs-validation" novalidate>
                        <div class="mb-4">
                            <label class="form-label">عنوان المحتوى</label>
                            <div class="input-group">
                                <span class="input-group-text" style="background: var(--blue); color: white;">
                                    <i class="fas fa-heading"></i>
                                </span>
                                <input type="text" name="title" class="form-control" required>
                            </div>
                            <div class="invalid-feedback">يرجى إدخال عنوان المحتوى</div>
                        </div>

                        <div class="mb-4">
                            <label class="form-label">نوع المحتوى</label>
                            <div class="input-group">
                                <span class="input-group-text" style="background: var(--blue); color: white;">
                                    <i class="fas fa-list"></i>
                                </span>
                                <select name="type_id" class="form-select" required>
                                    <option value="">اختر النوع</option>
                                    <?php foreach($content_types as $type): ?>
                                    <option value="<?php echo $type['id']; ?>">
                                        <?php echo $type['name']; ?>
                                    </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="invalid-feedback">يرجى اختيار نوع المحتوى</div>
                        </div>

                        <div class="mb-4">
                            <label class="form-label">الوصف</label>
                            <textarea name="description" class="form-control" rows="4" 
                                      style="resize: none;"></textarea>
                        </div>

                        <hr class="my-4">

                        <h5 class="mb-3" style="color: var(--dark-blue);">الأوامر الصوتية للقراء</h5>
                        
                        <div class="row g-3">
                            <?php foreach($readers as $reader): ?>
                            <div class="col-md-6">
                                <div class="card h-100" style="border: 1px solid var(--border-color);">
                                    <div class="card-body">
                                        <div class="form-check mb-2">
                                            <input type="checkbox" name="readers[]" 
                                                   value="<?php echo $reader['id']; ?>" 
                                                   class="form-check-input" 
                                                   id="reader_<?php echo $reader['id']; ?>">
                                            <label class="form-check-label fw-bold" 
                                                   for="reader_<?php echo $reader['id']; ?>">
                                                <?php echo $reader['name']; ?>
                                            </label>
                                        </div>
                                        <div class="input-group">
                                            <span class="input-group-text" style="background: var(--orange); color: white;">
                                                <i class="fas fa-microphone"></i>
                                            </span>
                                            <input type="text" name="command_<?php echo $reader['id']; ?>" 
                                                   class="form-control" 
                                                   placeholder="الأمر الصوتي">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>

                        <div class="d-flex justify-content-end gap-2 mt-4">
                            <a href="contents.php" class="btn btn-light">إلغاء</a>
                            <button type="submit" name="add_content" class="btn btn-primary">
                                <i class="fas fa-save me-1"></i>
                                حفظ المحتوى
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Tips Card -->
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">إرشادات</h5>
                </div>
                <div class="card-body">
                    <div class="alert" style="background: var(--light-blue); color: var(--dark-blue);">
                        <h6 class="alert-heading mb-2">
                            <i class="fas fa-info-circle me-1"></i>
                            نصائح مهمة
                        </h6>
                        <ul class="mb-0 ps-3">
                            <li>اختر عنواناً واضحاً ومعبراً</li>
                            <li>حدد نوع المحتوى بدقة</li>
                            <li>اكتب وصفاً مفيداً للمحتوى</li>
                            <li>تأكد من كتابة الأوامر الصوتية بشكل صحيح</li>
                        </ul>
                    </div>

                    <div class="alert" style="background: #fff3cd; color: var(--orange);">
                        <h6 class="alert-heading mb-2">
                            <i class="fas fa-exclamation-triangle me-1"></i>
                            تنبيه
                        </h6>
                        <p class="mb-0">تأكد من اختيار قارئ واحد على الأقل وكتابة الأمر الصوتي الخاص به</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// تفعيل التحقق من النموذج
(function() {
    'use strict';
    var forms = document.querySelectorAll('.needs-validation');
    Array.prototype.slice.call(forms).forEach(function(form) {
        form.addEventListener('submit', function(event) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            form.classList.add('was-validated');
        }, false);
    });
})();
</script>

<?php include 'includes/footer.php'; ?>