<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';
checkLogin();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['json_data'])) {
    try {
        // تحويل النص إلى JSON
        $data = json_decode($_POST['json_data'], true);
        if (!$data) {
            throw new Exception("صيغة JSON غير صحيحة");
        }

        $user_id = $_SESSION['user_id'];
        
        foreach ($data as $content_title => $readers_data) {
            // إضافة المحتوى
            $type_id = $conn->query("SELECT id FROM content_types WHERE name = 'دعاء' LIMIT 1")->fetch_assoc()['id'];
            
            $stmt = $conn->prepare("INSERT INTO contents (title, type_id, created_by) VALUES (?, ?, ?)");
            $stmt->bind_param("sii", $content_title, $type_id, $user_id);
            $stmt->execute();
            $content_id = $conn->insert_id;

            // إضافة القراء والروابط
            foreach ($readers_data as $reader_name => $media_path) {
                if ($reader_name === 'default') continue;

                // التحقق من وجود القارئ أو إضافته
                $reader_result = $conn->query("SELECT id FROM readers WHERE name = '" . $conn->real_escape_string($reader_name) . "' LIMIT 1");
                if ($reader_result->num_rows > 0) {
                    $reader_id = $reader_result->fetch_assoc()['id'];
                } else {
                    $stmt = $conn->prepare("INSERT INTO readers (name, created_by) VALUES (?, ?)");
                    $stmt->bind_param("si", $reader_name, $user_id);
                    $stmt->execute();
                    $reader_id = $conn->insert_id;
                }

                // إنشاء صيغة الأمر
                $command_phrase = "اطلبي من صوتيات الشيعة تشغيل " . $content_title . " بصوت " . $reader_name;

                // إضافة الربط بين المحتوى والقارئ
                $stmt = $conn->prepare("INSERT INTO content_readers (content_id, reader_id, command_phrase, created_by) VALUES (?, ?, ?, ?)");
                $stmt->bind_param("iisi", $content_id, $reader_id, $command_phrase, $user_id);
                $stmt->execute();
            }
        }

        setAlert('تم إضافة المحتوى بنجاح');
        header("Location: contents.php");
        exit();
    } catch (Exception $e) {
        setAlert('حدث خطأ: ' . $e->getMessage(), 'danger');
    }
}

include 'includes/header.php';
?>

<div class="container-fluid">
    <!-- Page Title -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="h4 mb-0" style="color: var(--dark-blue);">إضافة محتوى من JSON</h2>
        <a href="contents.php" class="btn" style="background: var(--orange); color: white;">
            <i class="fas fa-arrow-right me-1"></i>
            عودة للمحتويات
        </a>
    </div>

    <?php if($alert = getAlert()): ?>
        <div class="alert alert-<?php echo $alert['type']; ?> p-3 rounded-3">
            <?php echo $alert['message']; ?>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-lg-8">
            <!-- JSON Input Form -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">إدخال بيانات JSON</h5>
                </div>
                <div class="card-body">
                    <form method="POST" class="needs-validation" novalidate>
                        <div class="mb-4">
                            <label class="form-label">نص JSON</label>
                            <textarea name="json_data" 
                                      class="form-control json-input" 
                                      rows="15" 
                                      style="direction: ltr; font-family: monospace;" 
                                      required><?php echo isset($_POST['json_data']) ? htmlspecialchars($_POST['json_data']) : ''; ?></textarea>
                            <div class="invalid-feedback">يرجى إدخال نص JSON صحيح</div>
                        </div>

                        <div class="d-flex justify-content-end gap-2">
                            <a href="contents.php" class="btn btn-light">إلغاء</a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-1"></i>
                                حفظ المحتوى
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Tips Card -->
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">إرشادات</h5>
                </div>
                <div class="card-body">
                    <div class="alert" style="background: var(--light-blue); color: var(--dark-blue);">
                        <h6 class="alert-heading mb-2">
                            <i class="fas fa-info-circle me-1"></i>
                            صيغة JSON المطلوبة
                        </h6>
                        <pre style="direction: ltr;" class="mb-0"><code>{
    "اسم المحتوى": {
        "default": "مسار الملف",
        "اسم القارئ": "مسار الملف",
        ...
    }
}</code></pre>
                    </div>

                    <div class="alert" style="background: #fff3cd; color: var(--orange);">
                        <h6 class="alert-heading mb-2">
                            <i class="fas fa-exclamation-triangle me-1"></i>
                            تنبيه
                        </h6>
                        <p class="mb-0">تأكد من صحة صيغة JSON قبل الإضافة</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// تفعيل التحقق من النموذج
(function() {
    'use strict';
    var forms = document.querySelectorAll('.needs-validation');
    Array.prototype.slice.call(forms).forEach(function(form) {
        form.addEventListener('submit', function(event) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            form.classList.add('was-validated');
        }, false);
    });
})();
</script>

<?php include 'includes/footer.php'; ?>