<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';
checkLogin();

if(isset($_POST['add_reader'])) {
    $name = clean($_POST['name']);
    $description = clean($_POST['description']);
    $user_id = $_SESSION['user_id'];
    
    $query = "INSERT INTO readers (name, description, created_by) 
              VALUES ('$name', '$description', $user_id)";
    
    if($conn->query($query)) {
        setAlert('تم إضافة القارئ بنجاح');
        header("Location: readers.php");
        exit();
    } else {
        setAlert('حدث خطأ أثناء إضافة القارئ', 'danger');
    }
}

include 'includes/header.php';
?>

<div class="container-fluid">
    <!-- Page Title -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="h4 mb-0" style="color: var(--dark-blue);">إضافة قارئ جديد</h2>
        <a href="readers.php" class="btn" style="background: var(--orange); color: white;">
            <i class="fas fa-arrow-right me-1"></i>
            عودة للقراء
        </a>
    </div>

    <?php if($alert = getAlert()): ?>
        <div class="alert alert-<?php echo $alert['type']; ?> p-3 rounded-3">
            <?php echo $alert['message']; ?>
        </div>
    <?php endif; ?>

    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body p-4">
                    <form method="POST" class="needs-validation" novalidate>
                        <div class="mb-4">
                            <label class="form-label">اسم القارئ</label>
                            <div class="input-group">
                                <span class="input-group-text" style="background: var(--blue); color: white;">
                                    <i class="fas fa-user"></i>
                                </span>
                                <input type="text" name="name" class="form-control" required>
                            </div>
                            <div class="invalid-feedback">يرجى إدخال اسم القارئ</div>
                        </div>
                        
                        <div class="mb-4">
                            <label class="form-label">الوصف</label>
                            <textarea name="description" class="form-control" rows="4" 
                                      style="resize: none;"></textarea>
                        </div>
                        
                        <div class="d-flex justify-content-end gap-2">
                            <a href="readers.php" class="btn btn-light">إلغاء</a>
                            <button type="submit" name="add_reader" class="btn btn-primary">
                                <i class="fas fa-save me-1"></i>
                                حفظ القارئ
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// تفعيل التحقق من النموذج
(function() {
    'use strict';
    var forms = document.querySelectorAll('.needs-validation');
    Array.prototype.slice.call(forms).forEach(function(form) {
        form.addEventListener('submit', function(event) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            form.classList.add('was-validated');
        }, false);
    });
})();
</script>

<?php include 'includes/footer.php'; ?>