<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';
checkLogin();

if(!isAdmin()) {
    setAlert('ليس لديك صلاحية الوصول لهذه الصفحة', 'danger');
    header("Location: index.php");
    exit();
}

if(isset($_POST['add_user'])) {
    $username = clean($_POST['username']);
    $password = $_POST['password'];
    $email = clean($_POST['email']);
    $full_name = clean($_POST['full_name']);
    $role = clean($_POST['role']);
    
    // التحقق من عدم تكرار اسم المستخدم
    $check = $conn->query("SELECT id FROM users WHERE username = '$username'");
    if($check->num_rows == 0) {
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        
        $query = "INSERT INTO users (username, password, email, full_name, role) 
                  VALUES ('$username', '$hashed_password', '$email', '$full_name', '$role')";
        
        if($conn->query($query)) {
            setAlert('تم إضافة المستخدم بنجاح');
            header("Location: users.php");
            exit();
        } else {
            setAlert('حدث خطأ أثناء إضافة المستخدم', 'danger');
        }
    } else {
        setAlert('اسم المستخدم موجود مسبقاً', 'danger');
    }
}

include 'includes/header.php';
?>

<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">إضافة مستخدم جديد</h5>
                </div>
                <div class="card-body">
                    <?php if($alert = getAlert()): ?>
                        <div class="alert alert-<?php echo $alert['type']; ?>">
                            <?php echo $alert['message']; ?>
                        </div>
                    <?php endif; ?>

                    <form method="POST" class="needs-validation" novalidate>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">اسم المستخدم</label>
                                    <input type="text" name="username" class="form-control" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">كلمة المرور</label>
                                    <input type="password" name="password" class="form-control" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">البريد الإلكتروني</label>
                                    <input type="email" name="email" class="form-control" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">الاسم الكامل</label>
                                    <input type="text" name="full_name" class="form-control" required>
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">الصلاحية</label>
                            <select name="role" class="form-select" required>
                                <option value="editor">محرر</option>
                                <option value="admin">مدير</option>
                            </select>
                        </div>

                        <div class="text-end">
                            <a href="users.php" class="btn btn-light">إلغاء</a>
                            <button type="submit" name="add_user" class="btn btn-primary">إضافة المستخدم</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>