<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';
checkLogin();

// حذف أمر صوتي
if(isset($_GET['delete']) && isAdmin()) {
    $id = (int)$_GET['delete'];
    $conn->query("DELETE FROM content_readers WHERE id = $id");
    setAlert('تم حذف الأمر الصوتي بنجاح');
    header("Location: commands.php");
    exit();
}

include 'includes/header.php';

// جلب أنواع المحتوى للفلتر
$content_types = getContentTypes();
// جلب القراء للفلتر
$readers = getReaders();
?>

<div class="container-fluid">
    <!-- Page Title -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="h4 mb-0" style="color: var(--dark-blue);">الأوامر الصوتية</h2>
            <p class="text-muted mb-0">إدارة الأوامر الصوتية للمحتويات</p>
        </div>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCommandModal">
            <i class="fas fa-plus-circle me-1"></i>
            إضافة أمر صوتي
        </button>
    </div>

    <?php if($alert = getAlert()): ?>
        <div class="alert alert-<?php echo $alert['type']; ?> p-3 rounded-3">
            <?php echo $alert['message']; ?>
        </div>
    <?php endif; ?>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="stats-card primary">
                <div class="content">
                    <?php
                    $total_commands = $conn->query("SELECT COUNT(*) as total FROM content_readers WHERE status = 1")->fetch_assoc()['total'];
                    ?>
                    <div class="number"><?php echo $total_commands; ?></div>
                    <div class="label">إجمالي الأوامر</div>
                </div>
                <div class="icon">
                    <i class="fas fa-microphone"></i>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stats-card secondary">
                <div class="content">
                    <?php
                    $total_contents = $conn->query("SELECT COUNT(DISTINCT content_id) as total FROM content_readers WHERE status = 1")->fetch_assoc()['total'];
                    ?>
                    <div class="number"><?php echo $total_contents; ?></div>
                    <div class="label">المحتويات المرتبطة</div>
                </div>
                <div class="icon">
                    <i class="fas fa-book"></i>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stats-card third">
                <div class="content">
                    <?php
                    $total_readers = $conn->query("SELECT COUNT(DISTINCT reader_id) as total FROM content_readers WHERE status = 1")->fetch_assoc()['total'];
                    ?>
                    <div class="number"><?php echo $total_readers; ?></div>
                    <div class="label">القراء المشاركين</div>
                </div>
                <div class="icon">
                    <i class="fas fa-users"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Search & Filter -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-3">
                    <div class="input-group">
                        <span class="input-group-text" style="background: var(--blue); color: white;">
                            <i class="fas fa-search"></i>
                        </span>
                        <input type="text" name="search" class="form-control" 
                               placeholder="ابحث في الأوامر..."
                               value="<?php echo $_GET['search'] ?? ''; ?>">
                    </div>
                </div>
                <div class="col-md-3">
                    <select name="type" class="form-select">
                        <option value="">كل أنواع المحتوى</option>
                        <?php foreach($content_types as $type): ?>
                        <option value="<?php echo $type['id']; ?>" 
                                <?php echo (isset($_GET['type']) && $_GET['type'] == $type['id']) ? 'selected' : ''; ?>>
                            <?php echo $type['name']; ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <select name="reader" class="form-select">
                        <option value="">كل القراء</option>
                        <?php foreach($readers as $reader): ?>
                        <option value="<?php echo $reader['id']; ?>"
                                <?php echo (isset($_GET['reader']) && $_GET['reader'] == $reader['id']) ? 'selected' : ''; ?>>
                            <?php echo $reader['name']; ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn w-100" style="background: var(--orange); color: white;">
                        <i class="fas fa-filter me-1"></i>
                        تصفية
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Commands List -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">قائمة الأوامر الصوتية</h5>
            <div class="btn-group">
                <button type="button" class="btn btn-sm btn-light" title="تصدير Excel">
                    <i class="fas fa-file-excel" style="color: var(--blue);"></i>
                </button>
                <button type="button" class="btn btn-sm btn-light" title="طباعة">
                    <i class="fas fa-print" style="color: var(--orange);"></i>
                </button>
            </div>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead>
                        <tr>
                            <th class="py-3">المحتوى</th>
                            <th class="py-3">القارئ</th>
                            <th class="py-3">الأمر الصوتي</th>
                            <th class="py-3">أضيف بواسطة</th>
                            <th class="py-3">تاريخ الإضافة</th>
                            <th class="py-3">الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        // بناء الاستعلام
                        $where = "WHERE cr.status = 1";
                        if(isset($_GET['search']) && !empty($_GET['search'])) {
                            $search = clean($_GET['search']);
                            $where .= " AND (c.title LIKE '%$search%' OR cr.command_phrase LIKE '%$search%')";
                        }
                        if(isset($_GET['type']) && !empty($_GET['type'])) {
                            $type_id = (int)$_GET['type'];
                            $where .= " AND c.type_id = $type_id";
                        }
                        if(isset($_GET['reader']) && !empty($_GET['reader'])) {
                            $reader_id = (int)$_GET['reader'];
                            $where .= " AND cr.reader_id = $reader_id";
                        }

                        $query = "SELECT cr.*, c.title as content_title, ct.name as type_name,
                                 r.name as reader_name, u.username as added_by
                                 FROM content_readers cr
                                 JOIN contents c ON cr.content_id = c.id
                                 JOIN content_types ct ON c.type_id = ct.id
                                 JOIN readers r ON cr.reader_id = r.id
                                 JOIN users u ON cr.created_by = u.id
                                 $where
                                 ORDER BY cr.created_at DESC";
                        $commands = $conn->query($query);
                        
                        if($commands->num_rows > 0):
                            while($command = $commands->fetch_assoc()):
                        ?>
                        <tr>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="icon-box me-2" 
                                         style="background: var(--light-blue); width: 40px; height: 40px; 
                                                border-radius: 8px; display: flex; align-items: center; 
                                                justify-content: center;">
                                        <i class="fas fa-book" style="color: var(--dark-blue);"></i>
                                    </div>
                                    <div>
                                        <h6 class="mb-0"><?php echo $command['content_title']; ?></h6>
                                        <span class="badge" style="background: var(--blue);">
                                            <?php echo $command['type_name']; ?>
                                        </span>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-user-circle me-1" style="color: var(--orange);"></i>
                                    <?php echo $command['reader_name']; ?>
                                </div>
                            </td>
                            <td>
                                <code style="background: var(--gray-light); padding: 5px 10px; border-radius: 4px;">
                                    <?php echo $command['command_phrase']; ?>
                                </code>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-user me-1" style="color: var(--blue);"></i>
                                    <?php echo $command['added_by']; ?>
                                </div>
                            </td>
                            <td><?php echo formatDate($command['created_at']); ?></td>
                            <td>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-sm btn-light" 
                                            onclick="editCommand(<?php echo $command['id']; ?>)"
                                            title="تعديل">
                                        <i class="fas fa-edit" style="color: var(--blue);"></i>
                                    </button>
                                    <?php if(isAdmin()): ?>
                                    <a href="?delete=<?php echo $command['id']; ?>" 
                                       class="btn btn-sm btn-light" 
                                       onclick="return confirm('هل أنت متأكد من حذف هذا الأمر؟')"
                                       title="حذف">
                                        <i class="fas fa-trash" style="color: #dc3545;"></i>
                                    </a>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php 
                            endwhile;
                        else:
                        ?>
                        <tr>
                            <td colspan="6" class="text-center py-4">
                                <div class="d-flex flex-column align-items-center">
                                    <i class="fas fa-microphone fa-3x mb-2" style="color: var(--light-blue);"></i>
                                    <h5 style="color: var(--dark-blue);">لا توجد أوامر صوتية</h5>
                                    <p class="text-muted">قم بإضافة أوامر صوتية جديدة من خلال الزر أعلاه</p>
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal إضافة أمر صوتي -->
<div class="modal fade" id="addCommandModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">إضافة أمر صوتي جديد</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="add_command.php">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">المحتوى</label>
                        <select name="content_id" class="form-select" required>
                            <option value="">اختر المحتوى</option>
                            <?php
                            $contents = $conn->query("SELECT c.*, ct.name as type_name 
                                                    FROM contents c 
                                                    JOIN content_types ct ON c.type_id = ct.id 
                                                    WHERE c.status = 1 
                                                    ORDER BY c.title ASC");
                            while($content = $contents->fetch_assoc()):
                            ?>
                            <option value="<?php echo $content['id']; ?>">
                                <?php echo $content['title']; ?> (<?php echo $content['type_name']; ?>)
                            </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">القارئ</label>
                        <select name="reader_id" class="form-select" required>
                            <option value="">اختر القارئ</option>
                            <?php foreach($readers as $reader): ?>
                            <option value="<?php echo $reader['id']; ?>">
                                <?php echo $reader['name']; ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">الأمر الصوتي</label>
                        <input type="text" name="command_phrase" class="form-control" 
                               placeholder="مثال: شغل دعاء كميل بصوت فلان" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" name="add_command" class="btn btn-primary">إضافة</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>