<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';
checkLogin();

// حذف محتوى
if(isset($_GET['delete']) && isAdmin()) {
    $id = (int)$_GET['delete'];
    $conn->query("UPDATE contents SET status = 0 WHERE id = $id");
    setAlert('تم حذف المحتوى بنجاح');
    header("Location: contents.php");
    exit();
}

include 'includes/header.php';

// جلب أنواع المحتوى للفلتر
$content_types = getContentTypes();
?>

<div class="container-fluid">
    <!-- Page Title -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="h4 mb-0" style="color: var(--dark-blue);">إدارة المحتوى</h2>
        <a href="add_content.php" class="btn btn-primary">
            <i class="fas fa-plus-circle me-1"></i>
            إضافة محتوى جديد
        </a>
    </div>

    <?php if($alert = getAlert()): ?>
        <div class="alert alert-<?php echo $alert['type']; ?> p-3 rounded-3">
            <?php echo $alert['message']; ?>
        </div>
    <?php endif; ?>

    <!-- Search & Filter -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-4">
                    <div class="input-group">
                        <span class="input-group-text" style="background: var(--blue); color: white;">
                            <i class="fas fa-search"></i>
                        </span>
                        <input type="text" name="search" class="form-control" 
                               placeholder="ابحث في المحتوى..."
                               value="<?php echo $_GET['search'] ?? ''; ?>">
                    </div>
                </div>
                <div class="col-md-3">
                    <select name="type" class="form-select">
                        <option value="">كل الأنواع</option>
                        <?php foreach($content_types as $type): ?>
                        <option value="<?php echo $type['id']; ?>" 
                                <?php echo (isset($_GET['type']) && $_GET['type'] == $type['id']) ? 'selected' : ''; ?>>
                            <?php echo $type['name']; ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <select name="sort" class="form-select">
                        <option value="newest" <?php echo (!isset($_GET['sort']) || $_GET['sort'] == 'newest') ? 'selected' : ''; ?>>
                            الأحدث أولاً
                        </option>
                        <option value="oldest" <?php echo (isset($_GET['sort']) && $_GET['sort'] == 'oldest') ? 'selected' : ''; ?>>
                            الأقدم أولاً
                        </option>
                        <option value="title" <?php echo (isset($_GET['sort']) && $_GET['sort'] == 'title') ? 'selected' : ''; ?>>
                            حسب العنوان
                        </option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn w-100" 
                            style="background: var(--orange); color: white;">
                        <i class="fas fa-filter me-1"></i>
                        تصفية
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Content List -->
    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead>
                        <tr>
                            <th class="py-3">العنوان</th>
                            <th class="py-3">النوع</th>
                            <th class="py-3">عدد القراء</th>
                            <th class="py-3">أضيف بواسطة</th>
                            <th class="py-3">تاريخ الإضافة</th>
                            <th class="py-3">الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        // بناء الاستعلام
                        $where = "WHERE c.status = 1";
                        if(isset($_GET['search']) && !empty($_GET['search'])) {
                            $search = clean($_GET['search']);
                            $where .= " AND (c.title LIKE '%$search%' OR c.description LIKE '%$search%')";
                        }
                        if(isset($_GET['type']) && !empty($_GET['type'])) {
                            $type_id = (int)$_GET['type'];
                            $where .= " AND c.type_id = $type_id";
                        }

                        // الترتيب
                        $order = "ORDER BY c.created_at DESC";
                        if(isset($_GET['sort'])) {
                            switch($_GET['sort']) {
                                case 'oldest':
                                    $order = "ORDER BY c.created_at ASC";
                                    break;
                                case 'title':
                                    $order = "ORDER BY c.title ASC";
                                    break;
                            }
                        }

                        $query = "SELECT c.*, ct.name as type_name, u.username as added_by,
                                 (SELECT COUNT(*) FROM content_readers WHERE content_id = c.id) as readers_count
                                 FROM contents c 
                                 JOIN content_types ct ON c.type_id = ct.id 
                                 JOIN users u ON c.created_by = u.id 
                                 $where 
                                 $order";
                        $contents = $conn->query($query);
                        
                        if($contents->num_rows > 0):
                            while($content = $contents->fetch_assoc()):
                        ?>
                        <tr>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="icon-box me-2" 
                                         style="background: var(--light-blue); width: 40px; height: 40px; 
                                                border-radius: 8px; display: flex; align-items: center; 
                                                justify-content: center; color: var(--dark-blue);">
                                        <i class="fas fa-book"></i>
                                    </div>
                                    <div>
                                        <h6 class="mb-0"><?php echo $content['title']; ?></h6>
                                        <small class="text-muted">
                                            <?php echo mb_substr($content['description'], 0, 50); ?>...
                                        </small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge" style="background: var(--blue);">
                                    <?php echo $content['type_name']; ?>
                                </span>
                            </td>
                            <td>
                                <span class="badge" style="background: var(--orange);">
                                    <?php echo $content['readers_count']; ?> قارئ
                                </span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-user-circle me-1" style="color: var(--blue);"></i>
                                    <?php echo $content['added_by']; ?>
                                </div>
                            </td>
                            <td><?php echo formatDate($content['created_at']); ?></td>
                            <td>
                                <div class="btn-group">
                                    <a href="edit_content.php?id=<?php echo $content['id']; ?>" 
                                       class="btn btn-sm btn-light" title="تعديل">
                                        <i class="fas fa-edit" style="color: var(--blue);"></i>
                                    </a>
                                    <a href="manage_commands.php?content_id=<?php echo $content['id']; ?>" 
                                       class="btn btn-sm btn-light" title="إدارة الأوامر">
                                        <i class="fas fa-microphone" style="color: var(--orange);"></i>
                                    </a>
                                    <?php if(isAdmin()): ?>
                                    <a href="?delete=<?php echo $content['id']; ?>" 
                                       class="btn btn-sm btn-light" 
                                       onclick="return confirm('هل أنت متأكد من حذف هذا المحتوى؟')"
                                       title="حذف">
                                        <i class="fas fa-trash" style="color: #dc3545;"></i>
                                    </a>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php 
                            endwhile;
                        else:
                        ?>
                        <tr>
                            <td colspan="6" class="text-center py-4">
                                <div class="d-flex flex-column align-items-center">
                                    <i class="fas fa-book fa-3x mb-2" style="color: var(--light-blue);"></i>
                                    <h5 style="color: var(--dark-blue);">لا يوجد محتوى</h5>
                                    <p class="text-muted">قم بإضافة محتوى جديد من خلال الزر أعلاه</p>
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>