<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';
checkLogin();

if(!isset($_GET['id'])) {
    header("Location: commands.php");
    exit();
}

$id = (int)$_GET['id'];
$query = "SELECT cr.*, c.title as content_title, r.name as reader_name 
          FROM content_readers cr 
          JOIN contents c ON cr.content_id = c.id 
          JOIN readers r ON cr.reader_id = r.id 
          WHERE cr.id = $id AND cr.status = 1";
$result = $conn->query($query);

if($result->num_rows == 0) {
    setAlert('الأمر الصوتي غير موجود', 'danger');
    header("Location: commands.php");
    exit();
}

$command = $result->fetch_assoc();

if(isset($_POST['edit_command'])) {
    $command_phrase = clean($_POST['command_phrase']);
    
    $query = "UPDATE content_readers 
              SET command_phrase = '$command_phrase' 
              WHERE id = $id";
    
    if($conn->query($query)) {
        setAlert('تم تحديث الأمر الصوتي بنجاح');
        header("Location: commands.php");
        exit();
    } else {
        setAlert('حدث خطأ أثناء تحديث الأمر الصوتي', 'danger');
    }
}

include 'includes/header.php';
?>

<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">تعديل الأمر الصوتي</h5>
                    <a href="commands.php" class="btn btn-light btn-sm">
                        <i class="fas fa-arrow-right me-1"></i> عودة
                    </a>
                </div>
                <div class="card-body">
                    <?php if($alert = getAlert()): ?>
                        <div class="alert alert-<?php echo $alert['type']; ?>">
                            <?php echo $alert['message']; ?>
                        </div>
                    <?php endif; ?>

                    <form method="POST" class="needs-validation" novalidate>
                        <div class="mb-3">
                            <label class="form-label">المحتوى</label>
                            <input type="text" class="form-control" 
                                   value="<?php echo $command['content_title']; ?>" readonly>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">القارئ</label>
                            <input type="text" class="form-control" 
                                   value="<?php echo $command['reader_name']; ?>" readonly>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">الأمر الصوتي</label>
                            <input type="text" name="command_phrase" class="form-control" 
                                   value="<?php echo $command['command_phrase']; ?>" required>
                            <div class="form-text text-muted">
                                أدخل الأمر الصوتي كما سيتم نطقه للمساعد الصوتي
                            </div>
                            <div class="invalid-feedback">يرجى إدخال الأمر الصوتي</div>
                        </div>

                        <div class="text-end">
                            <a href="commands.php" class="btn btn-light">إلغاء</a>
                            <button type="submit" name="edit_command" class="btn btn-primary">
                                حفظ التغييرات
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- إضافة سكربت للتحقق من النموذج -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // سكربت التحقق من النموذج
    var forms = document.querySelectorAll('.needs-validation');
    Array.prototype.slice.call(forms).forEach(function(form) {
        form.addEventListener('submit', function(event) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            form.classList.add('was-validated');
        }, false);
    });
});
</script>

<?php include 'includes/footer.php'; ?>