<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';
checkLogin();

if(!isset($_GET['id'])) {
    header("Location: contents.php");
    exit();
}

$id = (int)$_GET['id'];
$query = "SELECT * FROM contents WHERE id = $id AND status = 1";
$result = $conn->query($query);

if($result->num_rows == 0) {
    setAlert('المحتوى غير موجود', 'danger');
    header("Location: contents.php");
    exit();
}

$content = $result->fetch_assoc();

// جلب الأوامر الصوتية الحالية
$current_commands = [];
$query = "SELECT * FROM content_readers WHERE content_id = $id";
$commands_result = $conn->query($query);
while($command = $commands_result->fetch_assoc()) {
    $current_commands[$command['reader_id']] = $command['command_phrase'];
}

if(isset($_POST['edit_content'])) {
    $title = clean($_POST['title']);
    $description = clean($_POST['description']);
    $type_id = (int)$_POST['type_id'];
    
    $query = "UPDATE contents 
              SET title = '$title', 
                  description = '$description', 
                  type_id = $type_id 
              WHERE id = $id";
    
    if($conn->query($query)) {
        // حذف الأوامر القديمة
        $conn->query("DELETE FROM content_readers WHERE content_id = $id");
        
        // إضافة الأوامر الجديدة
        if(isset($_POST['readers']) && is_array($_POST['readers'])) {
            foreach($_POST['readers'] as $reader_id) {
                $command = clean($_POST['command_'.$reader_id]);
                if(!empty($command)) {
                    $query = "INSERT INTO content_readers (content_id, reader_id, command_phrase, created_by) 
                             VALUES ($id, $reader_id, '$command', {$_SESSION['user_id']})";
                    $conn->query($query);
                }
            }
        }
        
        setAlert('تم تحديث المحتوى بنجاح');
        header("Location: contents.php");
        exit();
    } else {
        setAlert('حدث خطأ أثناء تحديث المحتوى', 'danger');
    }
}

// جلب أنواع المحتوى والقراء
$content_types = getContentTypes();
$readers = getReaders();

include 'includes/header.php';
?>

<div class="container-fluid">
    <!-- Page Title -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="h4 mb-0" style="color: var(--dark-blue);">تعديل المحتوى</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0 mt-1">
                    <li class="breadcrumb-item"><a href="contents.php" style="color: var(--blue);">المحتويات</a></li>
                    <li class="breadcrumb-item active"><?php echo $content['title']; ?></li>
                </ol>
            </nav>
        </div>
        <div class="d-flex gap-2">
            <a href="manage_commands.php?content_id=<?php echo $id; ?>" 
               class="btn" style="background: var(--orange); color: white;">
                <i class="fas fa-microphone me-1"></i>
                إدارة الأوامر
            </a>
            <a href="contents.php" class="btn btn-light">
                <i class="fas fa-arrow-right me-1"></i>
                عودة
            </a>
        </div>
    </div>

    <?php if($alert = getAlert()): ?>
        <div class="alert alert-<?php echo $alert['type']; ?> p-3 rounded-3">
            <?php echo $alert['message']; ?>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-lg-8">
            <!-- Content Information -->
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">معلومات المحتوى</h5>
                    <span class="badge" style="background: var(--blue);">
                        آخر تحديث: <?php echo formatDate($content['updated_at'] ?? $content['created_at']); ?>
                    </span>
                </div>
                <div class="card-body">
                    <form method="POST" class="needs-validation" novalidate>
                        <div class="mb-4">
                            <label class="form-label">عنوان المحتوى</label>
                            <div class="input-group">
                                <span class="input-group-text" style="background: var(--blue); color: white;">
                                    <i class="fas fa-heading"></i>
                                </span>
                                <input type="text" name="title" class="form-control" 
                                       value="<?php echo $content['title']; ?>" required>
                            </div>
                            <div class="invalid-feedback">يرجى إدخال عنوان المحتوى</div>
                        </div>

                        <div class="mb-4">
                            <label class="form-label">نوع المحتوى</label>
                            <div class="input-group">
                                <span class="input-group-text" style="background: var(--blue); color: white;">
                                    <i class="fas fa-list"></i>
                                </span>
                                <select name="type_id" class="form-select" required>
                                    <?php foreach($content_types as $type): ?>
                                    <option value="<?php echo $type['id']; ?>" 
                                            <?php echo ($type['id'] == $content['type_id']) ? 'selected' : ''; ?>>
                                        <?php echo $type['name']; ?>
                                    </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>

                        <div class="mb-4">
                            <label class="form-label">الوصف</label>
                            <textarea name="description" class="form-control" rows="4" 
                                      style="resize: none;"><?php echo $content['description']; ?></textarea>
                        </div>

                        <hr class="my-4">

                        <h5 class="mb-3" style="color: var(--dark-blue);">الأوامر الصوتية للقراء</h5>
                        
                        <div class="row g-3">
                            <?php foreach($readers as $reader): ?>
                            <div class="col-md-6">
                                <div class="card h-100" style="border: 1px solid var(--border-color);">
                                    <div class="card-body">
                                        <div class="form-check mb-2">
                                            <input type="checkbox" name="readers[]" 
                                                   value="<?php echo $reader['id']; ?>" 
                                                   class="form-check-input" 
                                                   id="reader_<?php echo $reader['id']; ?>"
                                                   <?php echo isset($current_commands[$reader['id']]) ? 'checked' : ''; ?>>
                                            <label class="form-check-label fw-bold" 
                                                   for="reader_<?php echo $reader['id']; ?>">
                                                <?php echo $reader['name']; ?>
                                            </label>
                                        </div>
                                        <div class="input-group">
                                            <span class="input-group-text" style="background: var(--orange); color: white;">
                                                <i class="fas fa-microphone"></i>
                                            </span>
                                            <input type="text" name="command_<?php echo $reader['id']; ?>" 
                                                   class="form-control" 
                                                   placeholder="الأمر الصوتي"
                                                   value="<?php echo $current_commands[$reader['id']] ?? ''; ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>

                        <div class="d-flex justify-content-end gap-2 mt-4">
                            <a href="contents.php" class="btn btn-light">إلغاء</a>
                            <button type="submit" name="edit_content" class="btn btn-primary">
                                <i class="fas fa-save me-1"></i>
                                حفظ التغييرات
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Content Stats -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">إحصائيات المحتوى</h5>
                </div>
                <div class="card-body">
                    <?php
                    $stats_query = "SELECT 
                        (SELECT COUNT(*) FROM content_readers WHERE content_id = $id) as commands_count,
                        (SELECT username FROM users WHERE id = {$content['created_by']}) as created_by,
                        created_at,
                        updated_at
                    FROM contents WHERE id = $id";
                    $stats = $conn->query($stats_query)->fetch_assoc();
                    ?>
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span>عدد الأوامر الصوتية</span>
                            <span class="badge" style="background: var(--blue);">
                                <?php echo $stats['commands_count']; ?>
                            </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span>أضيف بواسطة</span>
                            <span><?php echo $stats['created_by']; ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span>تاريخ الإضافة</span>
                            <span><?php echo formatDate($stats['created_at']); ?></span>
                        </li>
                        <?php if($stats['updated_at']): ?>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span>آخر تحديث</span>
                            <span><?php echo formatDate($stats['updated_at']); ?></span>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>

            <!-- Tips Card -->
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">إرشادات</h5>
                </div>
                <div class="card-body">
                    <div class="alert" style="background: var(--light-blue); color: var(--dark-blue);">
                        <h6 class="alert-heading mb-2">
                            <i class="fas fa-info-circle me-1"></i>
                            نصائح مهمة
                        </h6>
                        <ul class="mb-0 ps-3">
                            <li>تأكد من صحة جميع المعلومات</li>
                            <li>راجع الأوامر الصوتية</li>
                            <li>يمكنك إضافة أو إزالة القراء</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// تفعيل التحقق من النموذج
(function() {
    'use strict';
    var forms = document.querySelectorAll('.needs-validation');
    Array.prototype.slice.call(forms).forEach(function(form) {
        form.addEventListener('submit', function(event) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            form.classList.add('was-validated');
        }, false);
    });
})();
</script>

<?php include 'includes/footer.php'; ?>