<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';
checkLogin();

if(!isset($_GET['id'])) {
    header("Location: readers.php");
    exit();
}

$id = (int)$_GET['id'];
$query = "SELECT * FROM readers WHERE id = $id AND status = 1";
$result = $conn->query($query);

if($result->num_rows == 0) {
    setAlert('القارئ غير موجود', 'danger');
    header("Location: readers.php");
    exit();
}

$reader = $result->fetch_assoc();

if(isset($_POST['edit_reader'])) {
    $name = clean($_POST['name']);
    $description = clean($_POST['description']);
    
    $query = "UPDATE readers 
              SET name = '$name', 
                  description = '$description' 
              WHERE id = $id";
    
    if($conn->query($query)) {
        setAlert('تم تحديث بيانات القارئ بنجاح');
        header("Location: readers.php");
        exit();
    } else {
        setAlert('حدث خطأ أثناء تحديث البيانات', 'danger');
    }
}

include 'includes/header.php';
?>

<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">تعديل بيانات القارئ</h5>
                </div>
                <div class="card-body">
                    <?php if($alert = getAlert()): ?>
                        <div class="alert alert-<?php echo $alert['type']; ?>">
                            <?php echo $alert['message']; ?>
                        </div>
                    <?php endif; ?>

                    <form method="POST">
                        <div class="mb-3">
                            <label class="form-label">اسم القارئ</label>
                            <input type="text" name="name" class="form-control" 
                                   value="<?php echo $reader['name']; ?>" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">الوصف</label>
                            <textarea name="description" class="form-control" 
                                      rows="4"><?php echo $reader['description']; ?></textarea>
                        </div>
                        
                        <div class="text-end">
                            <a href="readers.php" class="btn btn-light">إلغاء</a>
                            <button type="submit" name="edit_reader" class="btn btn-primary">حفظ التغييرات</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>