<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';
checkLogin();

if(!isAdmin()) {
    setAlert('ليس لديك صلاحية الوصول لهذه الصفحة', 'danger');
    header("Location: index.php");
    exit();
}

if(!isset($_GET['id'])) {
    header("Location: users.php");
    exit();
}

$id = (int)$_GET['id'];
$query = "SELECT * FROM users WHERE id = $id AND status = 1";
$result = $conn->query($query);

if($result->num_rows == 0) {
    setAlert('المستخدم غير موجود', 'danger');
    header("Location: users.php");
    exit();
}

$user = $result->fetch_assoc();

if(isset($_POST['edit_user'])) {
    $email = clean($_POST['email']);
    $full_name = clean($_POST['full_name']);
    $role = clean($_POST['role']);
    
    $query = "UPDATE users SET 
              email = '$email',
              full_name = '$full_name'";
    
    // تحديث كلمة المرور إذا تم إدخالها
    if(!empty($_POST['password'])) {
        $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $query .= ", password = '$password'";
    }
    
    // تحديث الصلاحية إذا كان المستخدم ليس نفسه
    if($id != $_SESSION['user_id']) {
        $query .= ", role = '$role'";
    }
    
    $query .= " WHERE id = $id";
    
    if($conn->query($query)) {
        setAlert('تم تحديث بيانات المستخدم بنجاح');
        header("Location: users.php");
        exit();
    } else {
        setAlert('حدث خطأ أثناء تحديث البيانات', 'danger');
    }
}

include 'includes/header.php';
?>

<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">تعديل بيانات المستخدم</h5>
                </div>
                <div class="card-body">
                    <?php if($alert = getAlert()): ?>
                        <div class="alert alert-<?php echo $alert['type']; ?>">
                            <?php echo $alert['message']; ?>
                        </div>
                    <?php endif; ?>

                    <form method="POST">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">اسم المستخدم</label>
                                    <input type="text" class="form-control" value="<?php echo $user['username']; ?>" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">كلمة المرور الجديدة (اتركها فارغة إذا لم ترد تغييرها)</label>
                                    <input type="password" name="password" class="form-control">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">البريد الإلكتروني</label>
                                    <input type="email" name="email" class="form-control" 
                                           value="<?php echo $user['email']; ?>" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">الاسم الكامل</label>
                                    <input type="text" name="full_name" class="form-control" 
                                           value="<?php echo $user['full_name']; ?>" required>
                                </div>
                            </div>
                        </div>

                        <?php if($id != $_SESSION['user_id']): ?>
                        <div class="mb-3">
                            <label class="form-label">الصلاحية</label>
                            <select name="role" class="form-select" required>
                                <option value="editor" <?php echo $user['role'] == 'editor' ? 'selected' : ''; ?>>محرر</option>
                                <option value="admin" <?php echo $user['role'] == 'admin' ? 'selected' : ''; ?>>مدير</option>
                            </select>
                        </div>
                        <?php endif; ?>

                        <div class="text-end">
                            <a href="users.php" class="btn btn-light">إلغاء</a>
                            <button type="submit" name="edit_user" class="btn btn-primary">حفظ التغييرات</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>