<?php
if (!defined('BASE_PATH')) {
    require_once '../includes/config.php';
    require_once '../includes/functions.php';
}
checkLogin();
?>
<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لوحة التحكم - <?php echo SITE_NAME; ?></title>
    
    <!-- Bootstrap RTL CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Font: Cairo -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200;300;400;600;700;900&display=swap" rel="stylesheet">
    
    <!-- Custom CSS -->
    <style>
        :root {
            --orange: #fb8500;
            --yellow: #ffb703;
            --dark-blue: #023047;
            --blue: #219ebc;
            --light-blue: #8ecae6;
            --white: #ffffff;
            --gray-light: #f8f9fa;
            --border-color: #e0e0e0;
        }

        body {
            font-family: 'Cairo', sans-serif;
            background: var(--gray-light);
        }

        /* Sidebar Styles */
        .sidebar {
            background: var(--dark-blue);
            min-height: 100vh;
            width: 280px;
            position: fixed;
            right: 0;
            top: 0;
            padding: 20px 0;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            z-index: 1000;
        }

        .sidebar-header {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            margin-bottom: 20px;
        }

        .sidebar-header h3 {
            color: var(--white);
            margin: 0;
            font-size: 1.5rem;
        }

        .nav-sidebar .nav-item {
            padding: 0 15px;
            margin-bottom: 5px;
        }

        .nav-sidebar .nav-link {
            color: var(--light-blue);
            padding: 12px 20px;
            border-radius: 8px;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
        }

        .nav-sidebar .nav-link i {
            margin-left: 10px;
            width: 24px;
            text-align: center;
            font-size: 1.2rem;
        }

        .nav-sidebar .nav-link:hover,
        .nav-sidebar .nav-link.active {
            background: var(--orange);
            color: var(--white);
        }

        /* Main Content */
        .main-content {
            margin-right: 280px;
            padding: 20px;
        }

        /* Top Navbar */
        .top-navbar {
            background: var(--white);
            padding: 15px 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            margin-bottom: 30px;
        }

        .user-info {
            color: var(--dark-blue);
            font-weight: 600;
        }
        
        
        /*Status Style */
        
        /* إضافة في قسم الستايل */
            .stats-summary {
                background: var(--white);
                border-radius: 10px;
                padding: 20px;
                margin-bottom: 20px;
                box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            }
            
            .stats-summary .number {
                font-size: 1.8rem;
                font-weight: 700;
                color: var(--dark-blue);
                margin-bottom: 5px;
            }
            
            .stats-summary .label {
                color: var(--blue);
                font-size: 0.9rem;
            }
            
            .mini-chart {
                height: 150px;
                margin-top: 20px;
            }
        /*End Status Style*/
        
        /* Cards and Other Styles from your CSS file */
    </style>
</head>
<body>

<!-- Sidebar -->
<aside class="sidebar">
    <div class="sidebar-header">
        <h3><?php echo SITE_NAME; ?></h3>
    </div>
    
    <nav class="nav-sidebar">
        <div class="nav-item">
            <a href="index.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : ''; ?>">
                <i class="fas fa-home"></i>
                <span>الرئيسية</span>
            </a>
        </div>
        <div class="nav-item">
            <a href="readers.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'readers.php' ? 'active' : ''; ?>">
                <i class="fas fa-users"></i>
                <span>القراء</span>
            </a>
        </div>
        <div class="nav-item">
            <a href="contents.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'contents.php' ? 'active' : ''; ?>">
                <i class="fas fa-book"></i>
                <span>المحتوى</span>
            </a>
        </div>
        <div class="nav-item">
            <a href="commands.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'commands.php' ? 'active' : ''; ?>">
                <i class="fas fa-microphone"></i>
                <span>الأوامر الصوتية</span>
            </a>
        </div>
        
        <div class="nav-item">
            <a href="add_content_json.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'add_content_json.php' ? 'active' : ''; ?>">
                <i class="fas fa-microphone"></i>
                <span>إضافة محتوى JSON</span>
            </a>
        </div>
        
        <div class="nav-item">
            <a href="reports.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'reports.php' ? 'active' : ''; ?>">
                <i class="fas fa-microphone"></i>
                <span>متابعة البلاغات</span>
            </a>
        </div>
        
        
        <?php if(isAdmin()): ?>
        <div class="nav-item">
            <a href="users.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'users.php' ? 'active' : ''; ?>">
                <i class="fas fa-user-cog"></i>
                <span>المستخدمين</span>
            </a>
        </div>
        <?php endif; ?>
        
        <!-- إضافة هذا القسم في nav-sidebar قبل رابط تسجيل الخروج -->
<div class="nav-item">
    <a href="statistics.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'statistics.php' ? 'active' : ''; ?>">
        <i class="fas fa-chart-line"></i>
        <span>الإحصائيات</span>
    </a>
</div>

        <div class="nav-item">
            <a href="logout.php" class="nav-link">
                <i class="fas fa-sign-out-alt"></i>
                <span>تسجيل الخروج</span>
            </a>
        </div>
    </nav>
</aside>

<!-- Main Content -->
<div class="main-content">
    <!-- Top Navbar -->
    <nav class="top-navbar">
        <div class="d-flex justify-content-between align-items-center">
            <div class="d-flex align-items-center">
                <button class="btn btn-link d-lg-none me-2" id="sidebarToggle" 
                        style="color: var(--dark-blue);">
                    <i class="fas fa-bars"></i>
                </button>
                <div class="user-info">
                    <i class="fas fa-user-circle me-2"></i>
                    مرحباً، <?php echo $_SESSION['username']; ?>
                </div>
            </div>
            <div>
                <a href="../" class="btn btn-primary btn-sm" target="_blank">
                    <i class="fas fa-external-link-alt me-1"></i>
                    عرض الموقع
                </a>
            </div>
        </div>
    </nav>