<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';
require_once 'includes/header.php';

// جلب إحصائيات النظام
$stats = getStats();

// إحصائيات الزيارات
$today = date('Y-m-d');
$yesterday = date('Y-m-d', strtotime('-1 day'));
$last7Days = date('Y-m-d', strtotime('-7 days'));
$lastMonth = date('Y-m-d', strtotime('-30 days'));

// إحصائيات اليوم
$todayStats = $conn->query("
    SELECT COUNT(*) as visits, COUNT(DISTINCT ip_address) as unique_visitors 
    FROM visitors 
    WHERE DATE(visit_date) = '$today'
")->fetch_assoc();

// إحصائيات الأمس
$yesterdayStats = $conn->query("
    SELECT COUNT(*) as visits, COUNT(DISTINCT ip_address) as unique_visitors 
    FROM visitors 
    WHERE DATE(visit_date) = '$yesterday'
")->fetch_assoc();

// إحصائيات آخر 7 أيام
$weekStats = $conn->query("
    SELECT COUNT(*) as visits, COUNT(DISTINCT ip_address) as unique_visitors 
    FROM visitors 
    WHERE visit_date >= '$last7Days'
")->fetch_assoc();

// إحصائيات آخر 30 يوم
$monthStats = $conn->query("
    SELECT COUNT(*) as visits, COUNT(DISTINCT ip_address) as unique_visitors 
    FROM visitors 
    WHERE visit_date >= '$lastMonth'
")->fetch_assoc();

// إحصائيات النشاطات
$activityStats = $conn->query("
    SELECT 
        activity_type,
        COUNT(*) as total_count,
        COUNT(DISTINCT DATE(created_at)) as days_count,
        MIN(created_at) as first_activity,
        MAX(created_at) as last_activity
    FROM activities 
    GROUP BY activity_type
")->fetch_all(MYSQLI_ASSOC);

// أكثر المحتويات زيارة
$popularContent = $conn->query("
    SELECT c.title, COUNT(a.id) as views
    FROM contents c
    LEFT JOIN activities a ON c.id = a.content_id
    GROUP BY c.id
    ORDER BY views DESC
    LIMIT 10
");

// أكثر البلدان زيارة
$topCountries = $conn->query("
    SELECT country, COUNT(*) as visits
    FROM visitors
    WHERE visit_date >= '$lastMonth'
    GROUP BY country
    ORDER BY visits DESC
    LIMIT 10
");

// إحصائيات المحتوى حسب النوع
$contentStats = $conn->query("
    SELECT 
        ct.name as type_name,
        COUNT(c.id) as content_count,
        SUM(CASE WHEN c.status = 1 THEN 1 ELSE 0 END) as active_count,
        COUNT(cr.id) as commands_count
    FROM content_types ct
    LEFT JOIN contents c ON ct.id = c.type_id
    LEFT JOIN content_readers cr ON c.id = cr.content_id
    GROUP BY ct.id
    ORDER BY content_count DESC
");

// إحصائيات القراء
$readerStats = $conn->query("
    SELECT 
        r.name,
        r.status,
        COUNT(cr.id) as commands_count,
        COUNT(DISTINCT cr.content_id) as content_count
    FROM readers r
    LEFT JOIN content_readers cr ON r.id = cr.reader_id
    GROUP BY r.id
    ORDER BY commands_count DESC
    LIMIT 10
");

// آخر البلاغات
$recentReports = $conn->query("
    SELECT r.*, c.title as content_title 
    FROM reports r 
    LEFT JOIN contents c ON r.content_id = c.id 
    ORDER BY r.created_at DESC 
    LIMIT 10
");
?>

<style>
    :root {
        --orange: #fb8500;
        --yellow: #ffb703;
        --dark-blue: #023047;
        --blue: #219ebc;
        --light-blue: #8ecae6;
    }

    .dashboard-container {
        padding: 20px;
    }

    .stats-card {
        background: #fff;
        border-radius: 15px;
        padding: 25px;
        margin-bottom: 25px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
        border-right: 4px solid var(--orange);
        transition: transform 0.3s ease;
    }

    .stats-card:hover {
        transform: translateY(-5px);
    }

    .stats-icon {
        width: 60px;
        height: 60px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.8rem;
        margin-bottom: 20px;
    }

    .stats-number {
        font-size: 2.2rem;
        font-weight: 700;
        color: var(--dark-blue);
        margin-bottom: 10px;
    }

    .stats-label {
        color: var(--blue);
        font-size: 1rem;
        font-weight: 500;
    }

    .table-container {
        background: #fff;
        border-radius: 15px;
        padding: 25px;
        margin-bottom: 30px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
    }

    .table-header {
        margin-bottom: 20px;
        padding-bottom: 15px;
        border-bottom: 2px solid var(--light-blue);
    }

    .table-title {
        color: var(--dark-blue);
        margin: 0;
        font-size: 1.2rem;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .custom-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0;
    }

    .custom-table thead th {
        background: var(--dark-blue);
        color: #fff;
        padding: 12px;
        font-weight: 500;
        text-align: right;
    }

    .custom-table thead th:first-child {
        border-radius: 0 8px 8px 0;
    }

    .custom-table thead th:last-child {
        border-radius: 8px 0 0 8px;
    }

    .custom-table tbody tr {
        transition: all 0.3s ease;
    }

    .custom-table tbody tr:hover {
        background: rgba(142, 202, 230, 0.1);
    }

    .custom-table td {
        padding: 12px;
        border-bottom: 1px solid #eee;
        vertical-align: middle;
    }

    .badge {
        padding: 6px 12px;
        border-radius: 6px;
        font-weight: 500;
        font-size: 0.85rem;
    }

    .badge-primary { background: var(--blue); color: #fff; }
    .badge-success { background: var(--orange); color: #fff; }
    .badge-info { background: var(--light-blue); color: var(--dark-blue); }
    .badge-warning { background: var(--yellow); color: var(--dark-blue); }

    .summary-card {
        background: #fff;
        border-radius: 15px;
        padding: 20px;
        margin-bottom: 20px;
        border-right: 4px solid var(--blue);
    }

    .summary-title {
        color: var(--dark-blue);
        font-size: 1.1rem;
        margin-bottom: 15px;
        padding-bottom: 10px;
        border-bottom: 1px solid var(--light-blue);
    }

    .summary-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 8px 0;
        border-bottom: 1px dashed #eee;
    }

    .summary-label {
        color: var(--dark-blue);
        font-weight: 500;
    }

    .summary-value {
        font-weight: 600;
        color: var(--blue);
    }
</style>

<div class="dashboard-container">
    <!-- الإحصائيات العامة -->
    <div class="row">
        <!-- إحصائيات القراء -->
        <div class="col-md-3">
            <div class="stats-card">
                <div class="stats-icon" style="background: rgba(251, 133, 0, 0.1); color: var(--orange);">
                    <i class="fas fa-users"></i>
                </div>
                <div class="stats-number"><?php echo $stats['readers']; ?></div>
                <div class="stats-label">القراء النشطين</div>
            </div>
        </div>

        <!-- إحصائيات المحتوى -->
        <div class="col-md-3">
            <div class="stats-card">
                <div class="stats-icon" style="background: rgba(33, 158, 188, 0.1); color: var(--blue);">
                    <i class="fas fa-book"></i>
                </div>
                <div class="stats-number"><?php echo $stats['contents']; ?></div>
                <div class="stats-label">المحتويات المتاحة</div>
            </div>
        </div>

        <!-- إحصائيات الزيارات -->
        <div class="col-md-3">
            <div class="stats-card">
                <div class="stats-icon" style="background: rgba(2, 48, 71, 0.1); color: var(--dark-blue);">
                    <i class="fas fa-chart-line"></i>
                </div>
                <div class="stats-number"><?php echo $todayStats['visits']; ?></div>
                <div class="stats-label">زيارات اليوم</div>
            </div>
        </div>

        <!-- إحصائيات الأوامر -->
        <div class="col-md-3">
            <div class="stats-card">
                <div class="stats-icon" style="background: rgba(255, 183, 3, 0.1); color: var(--yellow);">
                    <i class="fas fa-microphone"></i>
                </div>
                <div class="stats-number"><?php echo $stats['commands']; ?></div>
                <div class="stats-label">الأوامر الصوتية</div>
            </div>
        </div>
    </div>

    <!-- ملخص الزيارات والنشاطات -->
    <div class="row">
        <!-- ملخص الزيارات -->
        <div class="col-md-6">
            <div class="summary-card">
                <h5 class="summary-title">
                    <i class="fas fa-chart-bar me-2" style="color: var(--blue)"></i>
                    ملخص الزيارات
                </h5>
                <div class="summary-item">
                    <span class="summary-label">زيارات اليوم</span>
                    <span class="summary-value"><?php echo number_format($todayStats['visits']); ?> زيارة</span>
                </div>
                <div class="summary-item">
                    <span class="summary-label">زوار اليوم الفريدين</span>
                    <span class="summary-value"><?php echo number_format($todayStats['unique_visitors']); ?> زائر</span>
                </div>
                <div class="summary-item">
                    <span class="summary-label">زيارات آخر 7 أيام</span>
                    <span class="summary-value"><?php echo number_format($weekStats['visits']); ?> زيارة</span>
                </div>
                <div class="summary-item">
                    <span class="summary-label">زيارات آخر 30 يوم</span>
                    <span class="summary-value"><?php echo number_format($monthStats['visits']); ?> زيارة</span>
                </div>
            </div>
        </div>

        <!-- ملخص النشاطات -->
        <div class="col-md-6">
            <div class="summary-card">
                <h5 class="summary-title">
                    <i class="fas fa-history me-2" style="color: var(--orange)"></i>
                    ملخص النشاطات
                </h5>
                <?php foreach($activityStats as $activity): ?>
                    <div class="summary-item">
                        <span class="summary-label">
                            <?php
                            switch($activity['activity_type']) {
                                case 'copy':
                                    echo '<i class="fas fa-copy text-primary me-2"></i>عمليات النسخ';
                                    break;
                                case 'search':
                                    echo '<i class="fas fa-search text-info me-2"></i>عمليات البحث';
                                    break;
                                case 'report':
                                    echo '<i class="fas fa-flag text-warning me-2"></i>البلاغات';
                                    break;
                            }
                            ?>
                        </span>
                        <span class="summary-value"><?php echo number_format($activity['total_count']); ?></span>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <!-- إحصائيات المحتوى -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="table-container">
                <div class="table-header">
                    <h5 class="table-title">
                        <i class="fas fa-book" style="color: var(--orange)"></i>
                        إحصائيات المحتوى
                    </h5>
                </div>
                <div class="table-responsive">
                    <table class="custom-table">
                        <thead>
                            <tr>
                                <th>نوع المحتوى</th>
                                <th>العدد الكلي</th>
                                <th>المحتوى النشط</th>
                                <th>الأوامر الصوتية</th>
                                <th>النسبة المئوية</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($stat = $contentStats->fetch_assoc()): ?>
                            <tr>
                                <td>
                                    <?php 
                                    $icon = '';
                                    switch(strtolower($stat['type_name'])) {
                                        case 'دعاء': $icon = '<i class="fas fa-pray text-success"></i>'; break;
                                        case 'زيارة': $icon = '<i class="fas fa-mosque text-info"></i>'; break;
                                        case 'أذان': $icon = '<i class="fas fa-volume-up text-warning"></i>'; break;
                                        case 'مناجاة': $icon = '<i class="fas fa-heart text-danger"></i>'; break;
                                        default: $icon = '<i class="fas fa-file-alt text-primary"></i>';
                                    }
                                    echo $icon . ' ' . htmlspecialchars($stat['type_name']); 
                                    ?>
                                </td>
                                <td><span class="badge badge-primary"><?php echo $stat['content_count']; ?></span></td>
                                <td><span class="badge badge-success"><?php echo $stat['active_count']; ?></span></td>
                                <td><span class="badge badge-info"><?php echo $stat['commands_count']; ?></span></td>
                                <td>
                                    <?php 
                                    $percentage = ($stat['content_count'] / $stats['contents']) * 100;
                                    echo '<span class="badge badge-warning">' . round($percentage, 1) . '%</span>';
                                    ?>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- إحصائيات القراء والبلاغات -->
    <div class="row">
        <!-- إحصائيات القراء -->
        <div class="col-md-6">
            <div class="table-container">
                <div class="table-header">
                    <h5 class="table-title">
                        <i class="fas fa-users" style="color: var(--blue)"></i>
                        إحصائيات القراء
                    </h5>
                </div>
                <div class="table-responsive">
                    <table class="custom-table">
                        <thead>
                            <tr>
                                <th>القارئ</th>
                                <th>الحالة</th>
                                <th>عدد الأوامر</th>
                                <th>المحتويات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($reader = $readerStats->fetch_assoc()): ?>
                            <tr>
                                <td>
                                    <i class="fas fa-user-circle text-primary me-2"></i>
                                    <?php echo htmlspecialchars($reader['name']); ?>
                                </td>
                                <td>
                                    <?php if($reader['status'] == 1): ?>
                                        <span class="badge badge-success">نشط</span>
                                    <?php else: ?>
                                        <span class="badge badge-warning">غير نشط</span>
                                    <?php endif; ?>
                                </td>
                                <td><span class="badge badge-primary"><?php echo $reader['commands_count']; ?></span></td>
                                <td><span class="badge badge-info"><?php echo $reader['content_count']; ?></span></td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- البلاغات -->
        <div class="col-md-6">
            <div class="table-container">
                <div class="table-header">
                    <h5 class="table-title">
                        <i class="fas fa-flag" style="color: var(--orange)"></i>
                        آخر البلاغات
                    </h5>
                </div>
                <div class="table-responsive">
                    <table class="custom-table">
                        <thead>
                            <tr>
                                <th>المحتوى</th>
                                <th>نوع المشكلة</th>
                                <th>الحالة</th>
                                <th>التاريخ</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($report = $recentReports->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($report['content_title']); ?></td>
                                <td>
                                    <span class="badge badge-<?php echo getIssueTypeBadge($report['issue_type']); ?>">
                                        <?php echo getIssueTypeArabic($report['issue_type']); ?>
                                    </span>
                                </td>
                                <td>
                                    <span class="badge badge-<?php echo getStatusBadge($report['status']); ?>">
                                        <?php echo getStatusArabic($report['status']); ?>
                                    </span>
                                </td>
                                <td><?php echo timeAgo($report['created_at']); ?></td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>