<?php
require_once '../includes/config.php';


if(isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

if(isset($_POST['login'])) {
    $username = clean($_POST['username']);
    $password = $_POST['password'];
    
    $query = "SELECT * FROM users WHERE username = '$username' AND status = 1";
    $result = $conn->query($query);
    
    if($result->num_rows == 1) {
        $user = $result->fetch_assoc();
        if(password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['user_role'] = $user['role'];
            
            // تحديث آخر تسجيل دخول
            $conn->query("UPDATE users SET last_login = NOW() WHERE id = {$user['id']}");
            
            header("Location: index.php");
            exit();
        }
    }
    
    setAlert('اسم المستخدم أو كلمة المرور غير صحيحة', 'danger');
}
?>

<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تسجيل الدخول - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200;300;400;600;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="bg-light">
    <div class="container">
        <div class="row justify-content-center mt-5">
            <div class="col-md-5">
                <div class="text-center mb-4">
                    <h2><?php echo SITE_NAME; ?></h2>
                    <p class="text-muted">لوحة التحكم</p>
                </div>
                
                <div class="card">
                    <div class="card-body p-4">
                        <?php if($alert = getAlert()): ?>
                            <div class="alert alert-<?php echo $alert['type']; ?>">
                                <?php echo $alert['message']; ?>
                            </div>
                        <?php endif; ?>

                        <form method="POST">
                            <div class="mb-3">
                                <label class="form-label">اسم المستخدم</label>
                                <input type="text" name="username" class="form-control" required>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">كلمة المرور</label>
                                <input type="password" name="password" class="form-control" required>
                            </div>
                            
                            <button type="submit" name="login" class="btn btn-primary w-100">
                                تسجيل الدخول
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>