<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';
checkLogin();

if(!isset($_GET['content_id'])) {
    header("Location: contents.php");
    exit();
}

$content_id = (int)$_GET['content_id'];

// جلب معلومات المحتوى
$query = "SELECT c.*, ct.name as type_name 
          FROM contents c 
          JOIN content_types ct ON c.type_id = ct.id 
          WHERE c.id = $content_id AND c.status = 1";
$result = $conn->query($query);

if($result->num_rows == 0) {
    setAlert('المحتوى غير موجود', 'danger');
    header("Location: contents.php");
    exit();
}

$content = $result->fetch_assoc();

// إضافة أمر صوتي جديد
if(isset($_POST['add_command'])) {
    $reader_id = (int)$_POST['reader_id'];
    $command = clean($_POST['command']);
    
    // التحقق من عدم وجود نفس الأمر للقارئ
    $check = $conn->query("SELECT id FROM content_readers 
                          WHERE content_id = $content_id 
                          AND reader_id = $reader_id 
                          AND status = 1");
    
    if($check->num_rows == 0) {
        $query = "INSERT INTO content_readers (content_id, reader_id, command_phrase, created_by) 
                  VALUES ($content_id, $reader_id, '$command', {$_SESSION['user_id']})";
        
        if($conn->query($query)) {
            setAlert('تم إضافة الأمر الصوتي بنجاح');
        } else {
            setAlert('حدث خطأ أثناء إضافة الأمر الصوتي', 'danger');
        }
    } else {
        setAlert('يوجد أمر صوتي مسجل مسبقاً لهذا القارئ', 'warning');
    }
}

// حذف أمر صوتي
if(isset($_GET['delete_command'])) {
    $command_id = (int)$_GET['delete_command'];
    if($conn->query("DELETE FROM content_readers WHERE id = $command_id AND content_id = $content_id")) {
        setAlert('تم حذف الأمر الصوتي بنجاح');
    }
}

include 'includes/header.php';
?>

<div class="container-fluid">
    <!-- Page Title -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="h4 mb-0" style="color: var(--dark-blue);">إدارة الأوامر الصوتية</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0 mt-1">
                    <li class="breadcrumb-item"><a href="contents.php" style="color: var(--blue);">المحتويات</a></li>
                    <li class="breadcrumb-item active"><?php echo $content['title']; ?></li>
                </ol>
            </nav>
        </div>
        <a href="edit_content.php?id=<?php echo $content_id; ?>" class="btn btn-light">
            <i class="fas fa-edit me-1"></i>
            تعديل المحتوى
        </a>
    </div>

    <?php if($alert = getAlert()): ?>
        <div class="alert alert-<?php echo $alert['type']; ?> p-3 rounded-3">
            <?php echo $alert['message']; ?>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-lg-4">
            <!-- Content Info -->
            <div class="card mb-4">
                <div class="card-body">
                    <div class="text-center mb-3">
                        <div class="icon-box mx-auto mb-3" 
                             style="background: var(--light-blue); width: 60px; height: 60px; 
                                    border-radius: 15px; display: flex; align-items: center; 
                                    justify-content: center;">
                            <i class="fas fa-book fa-2x" style="color: var(--dark-blue);"></i>
                        </div>
                        <h5 class="mb-1"><?php echo $content['title']; ?></h5>
                        <span class="badge" style="background: var(--blue);">
                            <?php echo $content['type_name']; ?>
                        </span>
                    </div>
                    <hr>
                    <div class="mb-3">
                        <label class="text-muted mb-1">الوصف</label>
                        <p class="mb-0"><?php echo $content['description'] ?: 'لا يوجد وصف'; ?></p>
                    </div>
                </div>
            </div>

            <!-- Add New Command -->
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">إضافة أمر صوتي جديد</h5>
                </div>
                <div class="card-body">
                    <form method="POST" class="needs-validation" novalidate>
                        <div class="mb-3">
                            <label class="form-label">القارئ</label>
                            <select name="reader_id" class="form-select" required>
                                <option value="">اختر القارئ</option>
                                <?php
                                $readers = $conn->query("SELECT r.* 
                                                       FROM readers r 
                                                       WHERE r.status = 1 
                                                       AND r.id NOT IN (
                                                           SELECT reader_id 
                                                           FROM content_readers 
                                                           WHERE content_id = $content_id
                                                       )
                                                       ORDER BY r.name ASC");
                                while($reader = $readers->fetch_assoc()):
                                ?>
                                <option value="<?php echo $reader['id']; ?>">
                                    <?php echo $reader['name']; ?>
                                </option>
                                <?php endwhile; ?>
                            </select>
                            <div class="invalid-feedback">يرجى اختيار القارئ</div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">الأمر الصوتي</label>
                            <div class="input-group">
                                <span class="input-group-text" style="background: var(--orange); color: white;">
                                    <i class="fas fa-microphone"></i>
                                </span>
                                <input type="text" name="command" class="form-control" 
                                       placeholder="مثال: شغل دعاء كميل بصوت فلان" required>
                            </div>
                            <div class="invalid-feedback">يرجى إدخال الأمر الصوتي</div>
                        </div>

                        <button type="submit" name="add_command" class="btn btn-primary w-100">
                            <i class="fas fa-plus-circle me-1"></i>
                            إضافة الأمر
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-8">
            <!-- Commands List -->
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">الأوامر الصوتية المسجلة</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead>
                                <tr>
                                    <th class="py-3">القارئ</th>
                                    <th class="py-3">الأمر الصوتي</th>
                                    <th class="py-3">أضيف بواسطة</th>
                                    <th class="py-3">تاريخ الإضافة</th>
                                    <th class="py-3">الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $commands_query = "SELECT cr.*, r.name as reader_name, u.username as added_by 
                                                 FROM content_readers cr 
                                                 JOIN readers r ON cr.reader_id = r.id 
                                                 JOIN users u ON cr.created_by = u.id 
                                                 WHERE cr.content_id = $content_id 
                                                 ORDER BY cr.created_at DESC";
                                $commands = $conn->query($commands_query);
                                
                                if($commands->num_rows > 0):
                                    while($command = $commands->fetch_assoc()):
                                ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="icon-box me-2" 
                                                 style="background: var(--light-blue); width: 35px; height: 35px; 
                                                        border-radius: 8px; display: flex; align-items: center; 
                                                        justify-content: center;">
                                                <i class="fas fa-user" style="color: var(--dark-blue);"></i>
                                            </div>
                                            <?php echo $command['reader_name']; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <code style="background: var(--gray-light); padding: 5px 10px; border-radius: 4px;">
                                            <?php echo $command['command_phrase']; ?>
                                        </code>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-user-circle me-1" style="color: var(--blue);"></i>
                                            <?php echo $command['added_by']; ?>
                                        </div>
                                    </td>
                                    <td><?php echo formatDate($command['created_at']); ?></td>
                                    <td>
                                        <a href="?content_id=<?php echo $content_id; ?>&delete_command=<?php echo $command['id']; ?>" 
                                           class="btn btn-sm btn-light" 
                                           onclick="return confirm('هل أنت متأكد من حذف هذا الأمر؟')"
                                           title="حذف">
                                            <i class="fas fa-trash" style="color: #dc3545;"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php 
                                    endwhile;
                                else:
                                ?>
                                <tr>
                                    <td colspan="5" class="text-center py-4">
                                        <div class="d-flex flex-column align-items-center">
                                            <i class="fas fa-microphone fa-3x mb-2" style="color: var(--light-blue);"></i>
                                            <h5 style="color: var(--dark-blue);">لا توجد أوامر صوتية</h5>
                                            <p class="text-muted">قم بإضافة أوامر صوتية جديدة من النموذج المجاور</p>
                                        </div>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// تفعيل التحقق من النموذج
(function() {
    'use strict';
    var forms = document.querySelectorAll('.needs-validation');
    Array.prototype.slice.call(forms).forEach(function(form) {
        form.addEventListener('submit', function(event) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            form.classList.add('was-validated');
        }, false);
    });
})();
</script>

<?php include 'includes/footer.php'; ?>