<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';
checkLogin();

// حذف قارئ
if(isset($_GET['delete']) && isAdmin()) {
    $id = (int)$_GET['delete'];
    $conn->query("UPDATE readers SET status = 0 WHERE id = $id");
    setAlert('تم حذف القارئ بنجاح');
    header("Location: readers.php");
    exit();
}

include 'includes/header.php';
?>

<div class="container-fluid">
    <!-- Page Title -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="h4 mb-0" style="color: var(--dark-blue);">إدارة القراء</h2>
        <a href="add_reader.php" class="btn btn-primary">
            <i class="fas fa-plus-circle me-1"></i>
            إضافة قارئ جديد
        </a>
    </div>

    <?php if($alert = getAlert()): ?>
        <div class="alert alert-<?php echo $alert['type']; ?> p-3 rounded-3">
            <?php echo $alert['message']; ?>
        </div>
    <?php endif; ?>

    <!-- Search & Filter -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-8">
                    <div class="input-group">
                        <span class="input-group-text" style="background: var(--blue); color: white;">
                            <i class="fas fa-search"></i>
                        </span>
                        <input type="text" name="search" class="form-control" 
                               placeholder="ابحث عن قارئ..."
                               value="<?php echo $_GET['search'] ?? ''; ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <button type="submit" class="btn w-100" 
                            style="background: var(--orange); color: white;">
                        <i class="fas fa-filter me-1"></i>
                        تصفية
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Readers List -->
    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead>
                        <tr>
                            <th class="py-3">#</th>
                            <th class="py-3">اسم القارئ</th>
                            <th class="py-3">عدد المحتويات</th>
                            <th class="py-3">أضيف بواسطة</th>
                            <th class="py-3">تاريخ الإضافة</th>
                            <th class="py-3">الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $search = isset($_GET['search']) ? clean($_GET['search']) : '';
                        $where = "WHERE r.status = 1";
                        if($search) {
                            $where .= " AND r.name LIKE '%$search%'";
                        }

                        $query = "SELECT r.*, u.username as added_by,
                                 (SELECT COUNT(*) FROM content_readers WHERE reader_id = r.id) as contents_count
                                 FROM readers r 
                                 JOIN users u ON r.created_by = u.id 
                                 $where 
                                 ORDER BY r.created_at DESC";
                        $readers = $conn->query($query);
                        
                        if($readers->num_rows > 0):
                            while($reader = $readers->fetch_assoc()):
                        ?>
                        <tr>
                            <td><?php echo $reader['id']; ?></td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="icon-box me-2" 
                                         style="background: var(--light-blue); width: 40px; height: 40px; 
                                                border-radius: 8px; display: flex; align-items: center; 
                                                justify-content: center; color: var(--dark-blue);">
                                        <i class="fas fa-user"></i>
                                    </div>
                                    <div>
                                        <h6 class="mb-0"><?php echo $reader['name']; ?></h6>
                                        <small class="text-muted"><?php echo mb_substr($reader['description'], 0, 50); ?>...</small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge" style="background: var(--blue);">
                                    <?php echo $reader['contents_count']; ?> محتوى
                                </span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-user-circle me-1" style="color: var(--blue);"></i>
                                    <?php echo $reader['added_by']; ?>
                                </div>
                            </td>
                            <td><?php echo formatDate($reader['created_at']); ?></td>
                            <td>
                                <div class="btn-group">
                                    <a href="edit_reader.php?id=<?php echo $reader['id']; ?>" 
                                       class="btn btn-sm btn-light" title="تعديل">
                                        <i class="fas fa-edit" style="color: var(--blue);"></i>
                                    </a>
                                    <a href="reader_contents.php?id=<?php echo $reader['id']; ?>" 
                                       class="btn btn-sm btn-light" title="عرض المحتويات">
                                        <i class="fas fa-book" style="color: var(--orange);"></i>
                                    </a>
                                    <?php if(isAdmin()): ?>
                                    <a href="?delete=<?php echo $reader['id']; ?>" 
                                       class="btn btn-sm btn-light" 
                                       onclick="return confirm('هل أنت متأكد من حذف هذا القارئ؟')"
                                       title="حذف">
                                        <i class="fas fa-trash" style="color: #dc3545;"></i>
                                    </a>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php 
                            endwhile;
                        else:
                        ?>
                        <tr>
                            <td colspan="6" class="text-center py-4">
                                <div class="d-flex flex-column align-items-center">
                                    <i class="fas fa-users fa-3x mb-2" style="color: var(--light-blue);"></i>
                                    <h5 style="color: var(--dark-blue);">لا يوجد قراء</h5>
                                    <p class="text-muted">قم بإضافة قراء جدد من خلال الزر أعلاه</p>
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>