<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';
checkLogin();

// معالجة تحديث حالة البلاغ
if(isset($_POST['update_status'])) {
    try {
        $report_id = (int)$_POST['report_id'];
        $status = $_POST['status'];
        $admin_notes = trim($_POST['admin_notes']);
        
        // التحقق من وجود البلاغ
        $report = getReportById($report_id);
        if (!$report) {
            throw new Exception("البلاغ غير موجود");
        }
        
        // تحديث حالة البلاغ
        $stmt = $conn->prepare("UPDATE reports SET status = ?, admin_notes = ?, updated_at = NOW() WHERE id = ?");
        if (!$stmt) {
            throw new Exception($conn->error);
        }
        
        $stmt->bind_param("ssi", $status, $admin_notes, $report_id);
        
        if ($stmt->execute()) {
            // إرسال بريد إلكتروني للمبلغ
            if (sendReportUpdateEmail($report['reporter_email'], $status, $admin_notes)) {
                $_SESSION['success'] = "تم تحديث حالة البلاغ وإرسال الإشعار بنجاح";
            } else {
                $_SESSION['warning'] = "تم تحديث حالة البلاغ ولكن فشل إرسال الإشعار";
            }
        } else {
            throw new Exception("فشل تحديث حالة البلاغ");
        }
        
        $stmt->close();
        
    } catch (Exception $e) {
        $_SESSION['error'] = $e->getMessage();
    }
    
    header("Location: reports.php");
    exit;
}

include 'includes/header.php';
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="h4 mb-0">إدارة البلاغات</h2>
    </div>

    <?php include 'includes/alerts.php'; ?>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>المحتوى</th>
                            <th>نوع المشكلة</th>
                            <th>المبلغ</th>
                            <th>الحالة</th>
                            <th>تاريخ البلاغ</th>
                            <th>آخر تحديث</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        // تعديل الاستعلام
                        $query = "SELECT r.*, c.title as content_title 
                                 FROM reports r
                                 LEFT JOIN contents c ON r.content_id = c.id
                                 ORDER BY r.created_at DESC";
                        $reports = $conn->query($query);
                        
                        if($reports && $reports->num_rows > 0):
                            while($report = $reports->fetch_assoc()):
                        ?>
                        <tr>
                            <td>#<?php echo $report['id']; ?></td>
                            <td>
                                <?php echo $report['content_title']; ?>
                            </td>
                            <td>
                                <span class="badge bg-<?php echo getIssueTypeBadge($report['issue_type']); ?>">
                                    <?php echo getIssueTypeArabic($report['issue_type']); ?>
                                </span>
                            </td>
                            <td>
                                <?php echo $report['reporter_name']; ?>
                                <br>
                                <small class="text-muted"><?php echo $report['reporter_email']; ?></small>
                            </td>
                            <td>
                                <span class="badge bg-<?php echo getStatusBadge($report['status']); ?>">
                                    <?php echo getStatusArabic($report['status']); ?>
                                </span>
                            </td>
                            <td><?php echo formatDate($report['created_at']); ?></td>
                            <td><?php echo formatDate($report['updated_at']); ?></td>
                            <td>
                                <button class="btn btn-sm btn-primary" 
                                        onclick="showUpdateModal(<?php echo htmlspecialchars(json_encode($report)); ?>)">
                                    <i class="fas fa-edit"></i>
                                    تحديث
                                </button>
                            </td>
                        </tr>
                        <?php 
                            endwhile;
                        else:
                        ?>
                        <tr>
                            <td colspan="8" class="text-center py-4">
                                <i class="fas fa-inbox fa-3x text-muted mb-3 d-block"></i>
                                <p class="mb-0">لا توجد بلاغات حالياً</p>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal تحديث حالة البلاغ -->
<div class="modal fade" id="updateStatusModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تحديث حالة البلاغ</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <div id="reportDetails" class="mb-3"></div>
                    <input type="hidden" name="report_id" id="update_report_id">
                    <div class="mb-3">
                        <label class="form-label">الحالة</label>
                        <select class="form-select" name="status" required>
                            <option value="pending">قيد الانتظار</option>
                            <option value="in_progress">قيد المعالجة</option>
                            <option value="resolved">تم الحل</option>
                            <option value="rejected">مرفوض</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">ملاحظات الإدارة</label>
                        <textarea class="form-control" name="admin_notes" rows="3"></textarea>
                        <small class="text-muted">سيتم إرسال هذه الملاحظات إلى المبلغ عبر البريد الإلكتروني</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                    <button type="submit" name="update_status" class="btn btn-primary">حفظ التغييرات</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function showUpdateModal(report) {
    document.getElementById('update_report_id').value = report.id;
    document.getElementById('reportDetails').innerHTML = `
        <div class="p-3 bg-light rounded">
            <h6 class="mb-2">تفاصيل البلاغ</h6>
            <p class="mb-1"><strong>المحتوى:</strong> ${report.content_title}</p>
            <p class="mb-1"><strong>المشكلة:</strong> ${report.description}</p>
            <p class="mb-0"><strong>المبلغ:</strong> ${report.reporter_name}</p>
        </div>
    `;
    
    document.querySelector('select[name="status"]').value = report.status;
    document.querySelector('textarea[name="admin_notes"]').value = report.admin_notes || '';
    
    const modal = new bootstrap.Modal(document.getElementById('updateStatusModal'));
    modal.show();
}
</script>

<?php include 'includes/footer.php'; ?>