<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';
checkLogin();

try {
    // تحديد الفترة
    $period = $_GET['period'] ?? 'week';
    
    // تحديد شرط التاريخ
    switch($period) {
        case 'today':
            $dateCondition = "DATE(v.visit_date) = CURDATE()";
            $dateConditionActivity = "DATE(a.created_at) = CURDATE()";
            $compareDate = "DATE_SUB(CURDATE(), INTERVAL 1 DAY)";
            $periodTitle = "اليوم";
            break;
        case 'yesterday':
            $dateCondition = "DATE(v.visit_date) = DATE_SUB(CURDATE(), INTERVAL 1 DAY)";
            $dateConditionActivity = "DATE(a.created_at) = DATE_SUB(CURDATE(), INTERVAL 1 DAY)";
            $compareDate = "DATE_SUB(CURDATE(), INTERVAL 2 DAY)";
            $periodTitle = "أمس";
            break;
        case 'week':
            $dateCondition = "v.visit_date >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)";
            $dateConditionActivity = "a.created_at >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)";
            $compareDate = "DATE_SUB(CURDATE(), INTERVAL 14 DAY)";
            $periodTitle = "آخر 7 أيام";
            break;
        case 'month':
            $dateCondition = "v.visit_date >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)";
            $dateConditionActivity = "a.created_at >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)";
            $compareDate = "DATE_SUB(CURDATE(), INTERVAL 60 DAY)";
            $periodTitle = "آخر 30 يوم";
            break;
        default:
            $dateCondition = "1=1";
            $dateConditionActivity = "1=1";
            $compareDate = "CURDATE()";
            $periodTitle = "كل الوقت";
    }

    // الإحصائيات الحالية
    $currentStats = [
        'visits' => $conn->query("SELECT COUNT(*) as count FROM visitors v WHERE {$dateCondition}")->fetch_assoc()['count'],
        'unique_visitors' => $conn->query("SELECT COUNT(DISTINCT v.ip_address) as count FROM visitors v WHERE {$dateCondition}")->fetch_assoc()['count'],
        'copies' => $conn->query("SELECT COUNT(*) as count FROM activities a WHERE a.activity_type = 'copy' AND {$dateConditionActivity}")->fetch_assoc()['count'],
        'searches' => $conn->query("SELECT COUNT(*) as count FROM activities a WHERE a.activity_type = 'search' AND {$dateConditionActivity}")->fetch_assoc()['count'],
        'reports' => $conn->query("SELECT COUNT(*) as count FROM activities a WHERE a.activity_type = 'report' AND {$dateConditionActivity}")->fetch_assoc()['count']
    ];

    // إحصائيات المقارنة
    $compareStats = [
        'visits' => $conn->query("SELECT COUNT(*) as count FROM visitors v WHERE DATE(v.visit_date) = {$compareDate}")->fetch_assoc()['count'],
        'copies' => $conn->query("SELECT COUNT(*) as count FROM activities a WHERE a.activity_type = 'copy' AND DATE(a.created_at) = {$compareDate}")->fetch_assoc()['count'],
        'searches' => $conn->query("SELECT COUNT(*) as count FROM activities a WHERE a.activity_type = 'search' AND DATE(a.created_at) = {$compareDate}")->fetch_assoc()['count']
    ];

    // المحتوى الأكثر نسخاً
$popularContent = $conn->query("
    SELECT 
        COALESCE(c.title, a.details) as title,
        COUNT(a.id) as count 
    FROM activities a 
    LEFT JOIN contents c ON a.content_id = c.id 
    WHERE a.activity_type = 'copy' 
    AND {$dateConditionActivity}
    GROUP BY COALESCE(c.title, a.details)
    ORDER BY count DESC 
    LIMIT 10
")->fetch_all(MYSQLI_ASSOC);


    // إحصائيات البلدان
    $countryStats = $conn->query("
        SELECT v.country, COUNT(*) as count 
        FROM visitors v 
        WHERE {$dateCondition}
        GROUP BY v.country 
        ORDER BY count DESC 
        LIMIT 10
    ")->fetch_all(MYSQLI_ASSOC);

    // إحصائيات المتصفحات
    $browserStats = $conn->query("
        SELECT 
            CASE 
                WHEN v.user_agent LIKE '%Chrome%' THEN 'Chrome'
                WHEN v.user_agent LIKE '%Firefox%' THEN 'Firefox'
                WHEN v.user_agent LIKE '%Safari%' THEN 'Safari'
                WHEN v.user_agent LIKE '%Edge%' THEN 'Edge'
                ELSE 'Other'
            END as browser,
            COUNT(*) as count
        FROM visitors v 
        WHERE {$dateCondition}
        GROUP BY browser
        ORDER BY count DESC
    ")->fetch_all(MYSQLI_ASSOC);

    // إحصائيات الزيارات حسب الساعة
    $hourlyStats = $conn->query("
        SELECT HOUR(v.visit_date) as hour, COUNT(*) as count 
        FROM visitors v 
        WHERE {$dateCondition}
        GROUP BY HOUR(v.visit_date)
        ORDER BY hour
    ")->fetch_all(MYSQLI_ASSOC);

    include 'includes/header.php';
?>

<div class="content-wrapper">
    <!-- رأس الصفحة -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <div>
                    <h2 class="h4 mb-1">لوحة الإحصائيات</h2>
                    <p class="text-muted mb-0">إحصائيات <?php echo $periodTitle; ?></p>
                </div>
                <div class="btn-group">
                    <a href="?period=today" class="btn btn-outline-primary <?php echo $period == 'today' ? 'active' : ''; ?>">
                        <i class="fas fa-calendar-day me-1"></i> اليوم
                    </a>
                    <a href="?period=yesterday" class="btn btn-outline-primary <?php echo $period == 'yesterday' ? 'active' : ''; ?>">
                        <i class="fas fa-calendar-minus me-1"></i> أمس
                    </a>
                    <a href="?period=week" class="btn btn-outline-primary <?php echo $period == 'week' ? 'active' : ''; ?>">
                        <i class="fas fa-calendar-week me-1"></i> الأسبوع
                    </a>
                    <a href="?period=month" class="btn btn-outline-primary <?php echo $period == 'month' ? 'active' : ''; ?>">
                        <i class="fas fa-calendar-alt me-1"></i> الشهر
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- المحتوى -->
    <div class="content">
        <div class="container-fluid">
            <!-- البطاقات الإحصائية -->
            <div class="row g-4 mb-4">
                <!-- إجمالي الزيارات -->
                <div class="col-xl-3 col-md-6">
                    <div class="stats-card primary">
                        <div class="content">
                            <div class="number"><?php echo number_format($currentStats['visits']); ?></div>
                            <div class="label">إجمالي الزيارات</div>
                            <?php if($period != 'all'): ?>
                            <div class="trend">
                                <?php 
                                $change = calculatePercentageChange($currentStats['visits'], $compareStats['visits']);
                                $trendClass = $change >= 0 ? 'text-success' : 'text-danger';
                                ?>
                                <span class="<?php echo $trendClass; ?>">
                                    <?php echo abs($change); ?>% 
                                    <i class="fas fa-<?php echo $change >= 0 ? 'arrow-up' : 'arrow-down'; ?>"></i>
                                </span>
                                مقارنة بالفترة السابقة
                            </div>
                            <?php endif; ?>
                        </div>
                        <div class="icon">
                            <i class="fas fa-users"></i>
                        </div>
                    </div>
                </div>

                <!-- الزوار الفريدين -->
                <div class="col-xl-3 col-md-6">
                    <div class="stats-card success">
                        <div class="content">
                            <div class="number"><?php echo number_format($currentStats['unique_visitors']); ?></div>
                            <div class="label">الزوار الفريدين</div>
                        </div>
                        <div class="icon">
                            <i class="fas fa-user-check"></i>
                        </div>
                    </div>
                </div>

                <!-- عمليات النسخ -->
                <div class="col-xl-3 col-md-6">
                    <div class="stats-card info">
                        <div class="content">
                            <div class="number"><?php echo number_format($currentStats['copies']); ?></div>
                            <div class="label">عمليات النسخ</div>
                            <?php if($period != 'all'): ?>
                            <div class="trend">
                                <?php 
                                $change = calculatePercentageChange($currentStats['copies'], $compareStats['copies']);
                                $trendClass = $change >= 0 ? 'text-success' : 'text-danger';
                                ?>
                                <span class="<?php echo $trendClass; ?>">
                                    <?php echo abs($change); ?>% 
                                    <i class="fas fa-<?php echo $change >= 0 ? 'arrow-up' : 'arrow-down'; ?>"></i>
                                </span>
                            </div>
                            <?php endif; ?>
                        </div>
                        <div class="icon">
                            <i class="fas fa-copy"></i>
                        </div>
                    </div>
                </div>

                <!-- عمليات البحث -->
                <div class="col-xl-3 col-md-6">
                    <div class="stats-card warning">
                        <div class="content">
                            <div class="number"><?php echo number_format($currentStats['searches']); ?></div>
                            <div class="label">عمليات البحث</div>
                            <?php if($period != 'all'): ?>
                            <div class="trend">
                                <?php 
                                $change = calculatePercentageChange($currentStats['searches'], $compareStats['searches']);
                                $trendClass = $change >= 0 ? 'text-success' : 'text-danger';
                                ?>
                                <span class="<?php echo $trendClass; ?>">
                                    <?php echo abs($change); ?>% 
                                    <i class="fas fa-<?php echo $change >= 0 ? 'arrow-up' : 'arrow-down'; ?>"></i>
                                </span>
                            </div>
                            <?php endif; ?>
                        </div>
                        <div class="icon">
                            <i class="fas fa-search"></i>
                        </div>
                    </div>
                </div>
            </div>

           <div class="row g-4 mb-4">
    <!-- تحليل الزيارات -->
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title mb-4">تحليل الزيارات</h5>
                <div class="chart-container">
                    <canvas id="visitsChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- الإحصائيات التفصيلية -->
<div class="row g-4">
    <!-- توزيع البلدان -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title mb-4">توزيع البلدان</h5>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>الدولة</th>
                                <th>عدد الزيارات</th>
                                <th>النسبة</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $totalVisits = array_sum(array_column($countryStats, 'count'));
                            foreach($countryStats as $index => $country): 
                                $percentage = ($country['count'] / $totalVisits) * 100;
                            ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td>
                                    <?php echo !empty($country['country']) ? $country['country'] : 'غير معروف'; ?>
                                </td>
                                <td>
                                    <span class="badge bg-primary">
                                        <?php echo number_format($country['count']); ?>
                                    </span>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="progress flex-grow-1" style="height: 5px;">
                                            <div class="progress-bar" role="progressbar" 
                                                 style="width: <?php echo $percentage; ?>%"></div>
                                        </div>
                                        <span class="ms-2"><?php echo number_format($percentage, 1); ?>%</span>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- توزيع المتصفحات -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title mb-4">توزيع المتصفحات</h5>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>المتصفح</th>
                                <th>عدد الزيارات</th>
                                <th>النسبة</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $totalBrowsers = array_sum(array_column($browserStats, 'count'));
                            foreach($browserStats as $index => $browser): 
                                $percentage = ($browser['count'] / $totalBrowsers) * 100;
                            ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td>
                                    <i class="fas fa-<?php 
                                        echo $browser['browser'] == 'Chrome' ? 'chrome' : 
                                            ($browser['browser'] == 'Firefox' ? 'firefox' : 
                                            ($browser['browser'] == 'Safari' ? 'safari' : 
                                            ($browser['browser'] == 'Edge' ? 'edge' : 'globe')));
                                    ?> me-2"></i>
                                    <?php echo $browser['browser']; ?>
                                </td>
                                <td>
                                    <span class="badge bg-primary">
                                        <?php echo number_format($browser['count']); ?>
                                    </span>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="progress flex-grow-1" style="height: 5px;">
                                            <div class="progress-bar" role="progressbar" 
                                                 style="width: <?php echo $percentage; ?>%"></div>
                                        </div>
                                        <span class="ms-2"><?php echo number_format($percentage, 1); ?>%</span>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- المحتوى الأكثر نسخاً -->
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title mb-4">المحتوى الأكثر نسخاً</h5>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>عنوان المحتوى</th>
                                <th>عدد مرات النسخ</th>
                                <th>النسبة</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $totalCopies = array_sum(array_column($popularContent, 'count'));
                            foreach($popularContent as $index => $content): 
                                $percentage = ($content['count'] / $totalCopies) * 100;
                            ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td><?php echo $content['title']; ?></td>
                                <td>
                                    <span class="badge bg-primary">
                                        <?php echo number_format($content['count']); ?>
                                    </span>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="progress flex-grow-1" style="height: 5px;">
                                            <div class="progress-bar" role="progressbar" 
                                                 style="width: <?php echo $percentage; ?>%"></div>
                                        </div>
                                        <span class="ms-2"><?php echo number_format($percentage, 1); ?>%</span>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
            
            
        </div>
    </div>
</div>


<style>
/* إزالة content-wrapper styles */
.content {
    padding: 20px;
    background-color: #f4f6f9;
    min-height: 100vh;
}

.stats-card {
    border-radius: 15px;
    padding: 25px;
    color: white;
    position: relative;
    overflow: hidden;
    transition: all 0.3s ease;
    height: 100%;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}

.stats-card.primary { background: linear-gradient(45deg, #6a11cb, #2575fc); }
.stats-card.success { background: linear-gradient(45deg, #00b09b, #96c93d); }
.stats-card.info { background: linear-gradient(45deg, #17a2b8, #89fffd); }
.stats-card.warning { background: linear-gradient(45deg, #f6d365, #fda085); }

.stats-card .content {
    position: relative;
    z-index: 1;
    /* تغيير padding لتجنب التداخل مع content class */
    padding: 0;
    background-color: transparent;
    min-height: auto;
}

.stats-card .icon {
    position: absolute;
    right: -20px;
    bottom: -20px;
    font-size: 5rem;
    opacity: 0.2;
    transform: rotate(-15deg);
}

.stats-card .number {
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 5px;
}

.stats-card .label {
    font-size: 1rem;
    opacity: 0.9;
    margin-bottom: 10px;
}

.stats-card .trend {
    font-size: 0.9rem;
    opacity: 0.9;
}

.card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 0 20px rgba(0,0,0,0.05);
}

.card-title {
    color: #495057;
    font-weight: 600;
}

.progress {
    background-color: #e9ecef;
    border-radius: 10px;
}

.progress-bar {
    background: linear-gradient(45deg, #6a11cb, #2575fc);
    border-radius: 10px;
}

.table th {
    font-weight: 600;
    color: #495057;
}

.badge {
    padding: 6px 12px;
    font-weight: 500;
}

.chart-container {
    position: relative;
    margin: auto;
    height: 300px;
}

/* إضافة أنماط جديدة للجداول */
.table {
    margin-bottom: 0;
}

.table th {
    font-weight: 600;
    background-color: #f8f9fa;
    border-bottom: 2px solid #dee2e6;
}

.table td {
    vertical-align: middle;
}

.progress {
    background-color: #e9ecef;
    border-radius: 10px;
    margin-right: 10px;
}

.progress-bar {
    background: linear-gradient(45deg, #6a11cb, #2575fc);
    border-radius: 10px;
}

.badge {
    padding: 6px 12px;
    font-weight: 500;
}

/* تحسين مظهر الأيقونات */
.fas {
    width: 20px;
    text-align: center;
}

.fa-chrome { color: #4285f4; }
.fa-firefox { color: #ff7139; }
.fa-safari { color: #000000; }
.fa-edge { color: #0078d7; }
.fa-globe { color: #666666; }

/* إضافة تحسينات للتجاوب */
@media (max-width: 768px) {
    .content {
        padding: 15px;
    }

    .stats-card {
        padding: 15px;
    }

    .stats-card .number {
        font-size: 2rem;
    }

    .chart-container {
        height: 250px;
    }
}
</style>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // تهيئة رسم بياني للزيارات
    new Chart(document.getElementById('visitsChart'), {
        type: 'line',
        data: {
            labels: <?php echo json_encode(array_column($hourlyStats, 'hour')); ?>,
            datasets: [{
                label: 'الزيارات',
                data: <?php echo json_encode(array_column($hourlyStats, 'count')); ?>,
                borderColor: '#2575fc',
                tension: 0.4,
                fill: true,
                backgroundColor: 'rgba(37, 117, 252, 0.1)'
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

});
</script>

<?php
    include 'includes/footer.php';
} catch (Exception $e) {
    error_log($e->getMessage());
    echo "<div class='alert alert-danger m-4'>";
    echo "<h4>حدث خطأ</h4>";
    echo "<p>تفاصيل الخطأ: " . $e->getMessage() . "</p>";
    echo "</div>";
}
?>