<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';
checkLogin();

// التحقق من الصلاحيات
if(!isAdmin()) {
    setAlert('ليس لديك صلاحية الوصول لهذه الصفحة', 'danger');
    header("Location: index.php");
    exit();
}

// حذف مستخدم
if(isset($_GET['delete']) && isAdmin()) {
    $id = (int)$_GET['delete'];
    if($id != $_SESSION['user_id']) {
        $conn->query("UPDATE users SET status = 0 WHERE id = $id");
        setAlert('تم حذف المستخدم بنجاح');
    }
    header("Location: users.php");
    exit();
}

include 'includes/header.php';
?>

<div class="container-fluid">
    <!-- Page Title -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="h4 mb-0" style="color: var(--dark-blue);">إدارة المستخدمين</h2>
            <p class="text-muted mb-0">إدارة حسابات المستخدمين والصلاحيات</p>
        </div>
        <a href="add_user.php" class="btn btn-primary">
            <i class="fas fa-user-plus me-1"></i>
            إضافة مستخدم جديد
        </a>
    </div>

    <?php if($alert = getAlert()): ?>
        <div class="alert alert-<?php echo $alert['type']; ?> p-3 rounded-3">
            <?php echo $alert['message']; ?>
        </div>
    <?php endif; ?>

    <!-- Users Stats -->
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="stats-card primary">
                <div class="content">
                    <?php
                    $total_users = $conn->query("SELECT COUNT(*) as total FROM users WHERE status = 1")->fetch_assoc()['total'];
                    ?>
                    <div class="number"><?php echo $total_users; ?></div>
                    <div class="label">إجمالي المستخدمين</div>
                </div>
                <div class="icon">
                    <i class="fas fa-users"></i>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stats-card secondary">
                <div class="content">
                    <?php
                    $total_admins = $conn->query("SELECT COUNT(*) as total FROM users WHERE status = 1 AND role = 'admin'")->fetch_assoc()['total'];
                    ?>
                    <div class="number"><?php echo $total_admins; ?></div>
                    <div class="label">المشرفين</div>
                </div>
                <div class="icon">
                    <i class="fas fa-user-shield"></i>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stats-card third">
                <div class="content">
                    <?php
                    $total_editors = $conn->query("SELECT COUNT(*) as total FROM users WHERE status = 1 AND role = 'editor'")->fetch_assoc()['total'];
                    ?>
                    <div class="number"><?php echo $total_editors; ?></div>
                    <div class="label">المحررين</div>
                </div>
                <div class="icon">
                    <i class="fas fa-user-edit"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Users List -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">قائمة المستخدمين</h5>
            <div class="btn-group">
                <button type="button" class="btn btn-sm btn-light" title="تصدير Excel">
                    <i class="fas fa-file-excel" style="color: var(--blue);"></i>
                </button>
                <button type="button" class="btn btn-sm btn-light" title="طباعة">
                    <i class="fas fa-print" style="color: var(--orange);"></i>
                </button>
            </div>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead>
                        <tr>
                            <th class="py-3">المستخدم</th>
                            <th class="py-3">البريد الإلكتروني</th>
                            <th class="py-3">الصلاحية</th>
                            <th class="py-3">النشاط</th>
                            <th class="py-3">آخر دخول</th>
                            <th class="py-3">الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $query = "SELECT * FROM users WHERE status = 1 ORDER BY id DESC";
                        $users = $conn->query($query);
                        while($user = $users->fetch_assoc()):
                            // إحصائيات المستخدم
                            $stats_query = "SELECT 
                                (SELECT COUNT(*) FROM contents WHERE created_by = {$user['id']}) as contents_count,
                                (SELECT COUNT(*) FROM content_readers WHERE created_by = {$user['id']}) as commands_count";
                            $stats = $conn->query($stats_query)->fetch_assoc();
                        ?>
                        <tr>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="icon-box me-2" 
                                         style="background: <?php echo $user['role'] == 'admin' ? 'var(--orange)' : 'var(--light-blue)'; ?>; 
                                                width: 40px; height: 40px; border-radius: 8px; 
                                                display: flex; align-items: center; justify-content: center;">
                                        <i class="fas <?php echo $user['role'] == 'admin' ? 'fa-user-shield' : 'fa-user'; ?>" 
                                           style="color: white;"></i>
                                    </div>
                                    <div>
                                        <h6 class="mb-0"><?php echo $user['full_name']; ?></h6>
                                        <small class="text-muted">@<?php echo $user['username']; ?></small>
                                    </div>
                                </div>
                            </td>
                            <td><?php echo $user['email']; ?></td>
                            <td>
                                <span class="badge" 
                                      style="background: <?php echo $user['role'] == 'admin' ? 'var(--orange)' : 'var(--blue)'; ?>;">
                                    <?php echo $user['role'] == 'admin' ? 'مشرف' : 'محرر'; ?>
                                </span>
                            </td>
                            <td>
                                <div class="d-flex gap-2">
                                    <span class="badge bg-light text-dark">
                                        <i class="fas fa-book me-1"></i>
                                        <?php echo $stats['contents_count']; ?> محتوى
                                    </span>
                                    <span class="badge bg-light text-dark">
                                        <i class="fas fa-microphone me-1"></i>
                                        <?php echo $stats['commands_count']; ?> أمر
                                    </span>
                                </div>
                            </td>
                            <td>
                                <?php if($user['last_login']): ?>
                                    <span title="<?php echo formatDate($user['last_login']); ?>">
                                        <?php echo timeAgo($user['last_login']); ?>
                                    </span>
                                <?php else: ?>
                                    <span class="text-muted">لم يسجل دخول بعد</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <a href="edit_user.php?id=<?php echo $user['id']; ?>" 
                                       class="btn btn-sm btn-light" title="تعديل">
                                        <i class="fas fa-edit" style="color: var(--blue);"></i>
                                    </a>
                                    <a href="user_activity.php?id=<?php echo $user['id']; ?>" 
                                       class="btn btn-sm btn-light" title="سجل النشاط">
                                        <i class="fas fa-history" style="color: var(--orange);"></i>
                                    </a>
                                    <?php if($user['id'] != $_SESSION['user_id']): ?>
                                    <a href="?delete=<?php echo $user['id']; ?>" 
                                       class="btn btn-sm btn-light" 
                                       onclick="return confirm('هل أنت متأكد من حذف هذا المستخدم؟')"
                                       title="حذف">
                                        <i class="fas fa-trash" style="color: #dc3545;"></i>
                                    </a>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>