<?php
header('Content-Type: application/json; charset=utf-8');

try {
    require_once '../includes/config.php';
    require_once '../includes/functions.php';
    
    // التحقق من طريقة الطلب
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('طريقة طلب غير صحيحة');
    }
    
    // التحقق من البيانات المطلوبة
    $required_fields = ['content_id', 'reporter_name', 'reporter_email', 'issue_type', 'description'];
    foreach ($required_fields as $field) {
        if (!isset($_POST[$field]) || empty(trim($_POST[$field]))) {
            throw new Exception("حقل {$field} مطلوب");
        }
    }
    
    // تنظيف وتحقق من البيانات
    $content_id = filter_var($_POST['content_id'], FILTER_VALIDATE_INT);
    $reporter_name = strip_tags(trim($_POST['reporter_name']));
    $reporter_email = filter_var(trim($_POST['reporter_email']), FILTER_VALIDATE_EMAIL);
    $issue_type = strip_tags(trim($_POST['issue_type']));
    $description = strip_tags(trim($_POST['description']));
    
    // التحقق من صحة البيانات
    if (!$content_id || !$reporter_email) {
        throw new Exception('بيانات غير صالحة');
    }
    
    // جلب عنوان المحتوى
    $content_title = $conn->query("SELECT title FROM contents WHERE id = $content_id")->fetch_assoc()['title'];
    
    // إدخال البلاغ
    $stmt = $conn->prepare("
        INSERT INTO reports 
        (content_id, reporter_name, reporter_email, issue_type, description) 
        VALUES (?, ?, ?, ?, ?)
    ");
    
    if (!$stmt) {
        throw new Exception($conn->error);
    }
    
    $stmt->bind_param('issss', 
        $content_id,
        $reporter_name,
        $reporter_email,
        $issue_type,
        $description
    );
    
    if ($stmt->execute()) {
        $report_id = $stmt->insert_id;
        
        // إعداد بيانات البلاغ لإرسال البريد
        $reportData = [
            'content_title' => $content_title,
            'reporter_name' => $reporter_name,
            'reporter_email' => $reporter_email,
            'issue_type' => $issue_type,
            'description' => $description
        ];
        
        // محاولة إرسال البريد الإلكتروني للإدارة
        if (sendNewReportNotification($reportData)) {
            echo json_encode([
                'success' => true,
                'message' => 'تم إرسال البلاغ وإشعار الإدارة بنجاح'
            ]);
        } else {
            echo json_encode([
                'success' => true,
                'message' => 'تم إرسال البلاغ ولكن فشل إرسال الإشعار للإدارة'
            ]);
        }
    } else {
        throw new Exception('فشل حفظ البلاغ');
    }
    
    $stmt->close();

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}

if (isset($conn)) {
    $conn->close();
}
?>