<?php
require_once '../includes/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json; charset=utf-8');

try {
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);
    
    if (!isset($data['type'])) {
        throw new Exception('Missing activity type');
    }
    
    // تنظيف وتحويل البيانات
    $type = filter_var($data['type'], FILTER_SANITIZE_STRING);
    $contentId = isset($data['content_id']) ? filter_var($data['content_id'], FILTER_SANITIZE_NUMBER_INT) : null;
    $details = isset($data['details']) ? filter_var($data['details'], FILTER_SANITIZE_STRING) : '';
    
    $success = trackActivity($type, $contentId, $details);
    
    echo json_encode(['success' => $success]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['error' => $e->getMessage()]);
}