<?php

date_default_timezone_set('Asia/Riyadh');
ini_set('session.cookie_httponly', 1);
session_start();

// معلومات الاتصال بقاعدة البيانات
define('DB_HOST', 'localhost');
define('DB_USER', 'jweblrdl_alexa_guide');
define('DB_PASS', 'Fadel@0553440015');
define('DB_NAME', 'jweblrdl_alexa_guide');

// معلومات النظام
define('SITE_NAME', 'صوتيات الشيعة');
define('SITE_URL', 'http://fadelapp/alexa_guide');
define('ADMIN_URL', SITE_URL . '/admin');

// منع عرض الأخطاء مباشرة
ini_set('display_errors', 0);
error_reporting(E_ALL);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/error.log');

// تعيين ترميز قاعدة البيانات
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// الاتصال بقاعدة البيانات
try {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    mysqli_set_charset($conn, "utf8mb4");
    ini_set('default_charset', 'UTF-8');
    $conn->set_charset("utf8mb4");
    
    if ($conn->connect_error) {
        throw new Exception("فشل الاتصال بقاعدة البيانات: " . $conn->connect_error);
    }
} catch (Exception $e) {
    die($e->getMessage());
}

// دوال مساعدة
function clean($string) {
    global $conn;
    return mysqli_real_escape_string($conn, trim($string));
}

function checkLogin() {
    if (!isset($_SESSION['user_id'])) {
        header("Location: login.php");
        exit();
    }
}

function isAdmin() {
    return isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin';
}

function getAlert() {
    if(isset($_SESSION['alert'])) {
        $alert = $_SESSION['alert'];
        unset($_SESSION['alert']);
        return $alert;
    }
    return null;
}

function setAlert($message, $type = 'success') {
    $_SESSION['alert'] = [
        'message' => $message,
        'type' => $type
    ];
}

function formatDate($date) {
    return date('Y-m-d H:i', strtotime($date));
}
?>