<?php
// دوال التحقق من الصلاحيات
function canManageUsers() {
    return isAdmin();
}

function canManageContent() {
    return isset($_SESSION['user_id']);
}

// دوال المستخدمين
function getUserById($id) {
    global $conn;
    $id = (int)$id;
    $query = "SELECT * FROM users WHERE id = $id";
    $result = $conn->query($query);
    return $result->fetch_assoc();
}

// دوال المحتوى
function getContentTypes() {
    global $conn;
    $query = "SELECT * FROM content_types WHERE status = 1";
    $result = $conn->query($query);
    $types = [];
    while($row = $result->fetch_assoc()) {
        $types[] = $row;
    }
    return $types;
}

function getReaders() {
    global $conn;
    $query = "SELECT * FROM readers WHERE status = 1";
    $result = $conn->query($query);
    $readers = [];
    while($row = $result->fetch_assoc()) {
        $readers[] = $row;
    }
    return $readers;
}

// دوال الإحصائيات
function getStats() {
    global $conn;
    
    $stats = [
        'readers' => 0,
        'contents' => 0,
        'commands' => 0
    ];
    
    $query = "SELECT COUNT(*) as total FROM readers WHERE status = 1";
    $result = $conn->query($query);
    $stats['readers'] = $result->fetch_assoc()['total'];
    
    $query = "SELECT COUNT(*) as total FROM contents WHERE status = 1";
    $result = $conn->query($query);
    $stats['contents'] = $result->fetch_assoc()['total'];
    
    $query = "SELECT COUNT(*) as total FROM content_readers WHERE status = 1";
    $result = $conn->query($query);
    $stats['commands'] = $result->fetch_assoc()['total'];
    
    return $stats;
}

// في ملف includes/functions.php أضف هذه الدالة

function timeAgo($datetime) {
    $time = strtotime($datetime);
    $current = time();
    $diff = $current - $time;
    
    $intervals = array(
        31536000 => 'سنة',
        2592000 => 'شهر',
        604800 => 'أسبوع',
        86400 => 'يوم',
        3600 => 'ساعة',
        60 => 'دقيقة',
        1 => 'ثانية'
    );
    
    foreach ($intervals as $seconds => $label) {
        $interval = floor($diff / $seconds);
        
        if ($interval >= 1) {
            if ($interval > 1) {
                // معالجة الجمع في اللغة العربية
                switch ($label) {
                    case 'سنة':
                        $label = 'سنوات';
                        break;
                    case 'شهر':
                        $label = 'أشهر';
                        break;
                    case 'أسبوع':
                        $label = 'أسابيع';
                        break;
                    case 'يوم':
                        $label = 'أيام';
                        break;
                    case 'ساعة':
                        $label = 'ساعات';
                        break;
                    case 'دقيقة':
                        $label = 'دقائق';
                        break;
                    case 'ثانية':
                        $label = 'ثواني';
                        break;
                }
            }
            
            return "منذ $interval $label";
        }
    }
    
    return "الآن";
}




/**
 * دالة جلب البلاغ بواسطة المعرف
 */
function getReportById($id) {
    global $conn;
    
    $stmt = $conn->prepare("
        SELECT r.*, c.title as content_title 
        FROM reports r
        LEFT JOIN contents c ON r.content_id = c.id
        WHERE r.id = ?
    ");
    
    if (!$stmt) {
        return null;
    }
    
    $stmt->bind_param('i', $id);
    
    if (!$stmt->execute()) {
        return null;
    }
    
    $result = $stmt->get_result();
    $report = $result->fetch_assoc();
    
    $stmt->close();
    
    return $report;
}

/**
 * دالة إرسال بريد إلكتروني للمبلغ عند تحديث حالة البلاغ
 */
function sendReportUpdateEmail($email, $status, $notes) {
    $subject = "تحديث حالة البلاغ - صوتيات الشيعة";
    
    $message = "السلام عليكم ورحمة الله وبركاته،\n\n";
    $message .= "تم تحديث حالة بلاغك إلى: " . getStatusArabic($status) . "\n\n";
    
    if (!empty($notes)) {
        $message .= "ملاحظات الإدارة:\n" . $notes . "\n\n";
    }
    
    $message .= "شكراً لتواصلك معنا،\n";
    $message .= "فريق صوتيات الشيعة";
    
    $headers = "From: fadel.vb.net@gmail.com\r\n";
    $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
    
    return mail($email, $subject, $message, $headers);
}

/**
 * دالة تحويل حالة البلاغ إلى النص العربي
 */
function getStatusArabic($status) {
    $statuses = [
        'pending' => 'قيد الانتظار',
        'in_progress' => 'قيد المعالجة',
        'resolved' => 'تم الحل',
        'rejected' => 'مرفوض'
    ];
    return $statuses[$status] ?? $status;
}

/**
 * دالة تحديد لون الحالة
 */
function getStatusBadge($status) {
    $badges = [
        'pending' => 'warning',
        'in_progress' => 'info',
        'resolved' => 'success',
        'rejected' => 'danger'
    ];
    return $badges[$status] ?? 'secondary';
}

/**
 * دالة تحويل نوع المشكلة إلى النص العربي
 */
function getIssueTypeArabic($type) {
    $types = [
        'not_working' => 'لا يعمل',
        'wrong_content' => 'محتوى خاطئ',
        'bad_quality' => 'جودة رديئة',
        'other' => 'مشكلة أخرى'
    ];
    return $types[$type] ?? $type;
}

/**
 * دالة تحديد لون نوع المشكلة
 */
function getIssueTypeBadge($type) {
    $badges = [
        'not_working' => 'danger',
        'wrong_content' => 'warning',
        'bad_quality' => 'info',
        'other' => 'secondary'
    ];
    return $badges[$type] ?? 'secondary';
}


/**
 * دالة إرسال بريد إلكتروني للإدارة عند استلام بلاغ جديد
 */
function sendNewReportNotification($reportData) {
    // جلب بريد الإدارة
    global $conn;
    $admin_email = $conn->query("SELECT email FROM users WHERE role = 'admin' LIMIT 1")->fetch_assoc()['email'];
    
    $subject = "بلاغ جديد - " . SITE_NAME;
    
    $message = "السلام عليكم ورحمة الله وبركاته،\n\n";
    $message .= "تم استلام بلاغ جديد بالتفاصيل التالية:\n\n";
    $message .= "المحتوى: " . $reportData['content_title'] . "\n";
    $message .= "اسم المبلغ: " . $reportData['reporter_name'] . "\n";
    $message .= "البريد الإلكتروني: " . $reportData['reporter_email'] . "\n";
    $message .= "نوع المشكلة: " . getIssueTypeArabic($reportData['issue_type']) . "\n";
    $message .= "الوصف: " . $reportData['description'] . "\n\n";
    $message .= "يمكنك مراجعة البلاغ من خلال لوحة التحكم\n\n";
    $message .= "مع التحية،\n";
    $message .= SITE_NAME;
    
    $headers = "From: " . SITE_NAME . " <no-reply@" . $_SERVER['HTTP_HOST'] . ">\r\n";
    $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
    
    return mail($admin_email, $subject, $message, $headers);
}


/**
 * تتبع الزيارات
 */

function trackVisit() {
    global $conn;
    
    try {
        // تعيين الترميز للاتصال
        $conn->set_charset("utf8mb4");
        
        // جمع معلومات الزيارة
        $ip = $_SERVER['REMOTE_ADDR'];
        $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
        $pageUrl = $_SERVER['REQUEST_URI'] ?? '';
        $sessionId = session_id();
        
        // الحصول على معلومات البلد والمدينة
        $country = 'غير معروف';
        $city = 'غير معروف';
        
        try {
            $ipInfo = @file_get_contents("http://ip-api.com/json/{$ip}?fields=country,city&lang=ar");
            if ($ipInfo) {
                $ipData = json_decode($ipInfo);
                if ($ipData && isset($ipData->country)) {
                    $country = $ipData->country;
                    $city = $ipData->city ?? 'غير معروف';
                }
            }
        } catch (Exception $e) {
            error_log("IP API Error: " . $e->getMessage());
        }

        // التحقق من وجود الجدول وإنشائه إذا لم يكن موجوداً
        $checkTable = $conn->query("SHOW TABLES LIKE 'visitors'");
        if ($checkTable->num_rows == 0) {
            $createTable = "
                CREATE TABLE IF NOT EXISTS visitors (
                    id INT PRIMARY KEY AUTO_INCREMENT,
                    ip_address VARCHAR(45),
                    user_agent TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
                    page_url VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
                    country VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
                    city VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
                    session_id VARCHAR(255),
                    visit_date DATETIME DEFAULT CURRENT_TIMESTAMP
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
            ";
            
            if (!$conn->query($createTable)) {
                throw new Exception("Error creating table: " . $conn->error);
            }
        }
        
        // تسجيل الزيارة مع معلومات البلد والمدينة
        $stmt = $conn->prepare("
            INSERT INTO visitors 
            (ip_address, user_agent, page_url, country, city, session_id) 
            VALUES (?, ?, ?, ?, ?, ?)
        ");
        
        if (!$stmt) {
            throw new Exception("Prepare failed: " . $conn->error);
        }
        
        $stmt->bind_param("ssssss", $ip, $userAgent, $pageUrl, $country, $city, $sessionId);
        
        if (!$stmt->execute()) {
            throw new Exception("Execute failed: " . $stmt->error);
        }
        
        $stmt->close();
        
        // تحديث الإحصائيات اليومية
        $today = date('Y-m-d');
        $updateStats = "
            INSERT INTO daily_stats (stat_date, visits, unique_visitors) 
            VALUES ('$today', 1, 1)
            ON DUPLICATE KEY UPDATE 
                visits = visits + 1,
                unique_visitors = (
                    SELECT COUNT(DISTINCT ip_address) 
                    FROM visitors 
                    WHERE DATE(visit_date) = '$today'
                )
        ";
        
        $conn->query($updateStats);
        
        return true;
        
    } catch (Exception $e) {
        error_log("Error tracking visit: " . $e->getMessage());
        return false;
    }
}


/**
 * دالة مساعدة للتحقق من صحة الترميز
 */
function fixEncoding($string) {
    if (!mb_check_encoding($string, 'UTF-8')
        || !($string === mb_convert_encoding(mb_convert_encoding($string, 'UTF-32', 'UTF-8'), 'UTF-8', 'UTF-32'))) {
        $string = mb_convert_encoding($string, 'UTF-8');
    }
    return $string;
}

/**
 * تتبع النشاطات
 */
/**
 * تتبع النشاطات
 */
function trackActivity($type, $contentId = null, $details = '') {
    global $conn;
    
    try {
        // تعيين الترميز للاتصال
        $conn->set_charset("utf8mb4");
        
        // التحقق من نوع النشاط
        $validTypes = ['copy', 'search', 'report'];
        if (!in_array($type, $validTypes)) {
            return false;
        }
        
        // جمع المعلومات
        $ip = $_SERVER['REMOTE_ADDR'];
        $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
        
        // الحصول على معلومات البلد
        $country = 'غير معروف';
        try {
            $ipInfo = @file_get_contents("http://ip-api.com/json/{$ip}?fields=country&lang=ar");
            if ($ipInfo) {
                $ipData = json_decode($ipInfo);
                if ($ipData && isset($ipData->country)) {
                    $country = $ipData->country;
                }
            }
        } catch (Exception $e) {
            error_log("IP API Error in trackActivity: " . $e->getMessage());
        }

        // التأكد من الترميز الصحيح للتفاصيل
        $details = mb_convert_encoding($details, 'UTF-8', mb_detect_encoding($details));
        
        // التحقق من وجود الجدول
        $checkTable = $conn->query("SHOW TABLES LIKE 'activities'");
        if ($checkTable->num_rows == 0) {
            $createTable = "
                CREATE TABLE IF NOT EXISTS activities (
                    id INT PRIMARY KEY AUTO_INCREMENT,
                    activity_type ENUM('copy', 'search', 'report'),
                    content_id INT NULL,
                    ip_address VARCHAR(45),
                    user_agent TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
                    country VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
                    details TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
                    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                    FOREIGN KEY (content_id) REFERENCES contents(id) ON DELETE SET NULL
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
            ";
            
            if (!$conn->query($createTable)) {
                throw new Exception("Error creating activities table: " . $conn->error);
            }
        }
        
        // تسجيل النشاط
        $stmt = $conn->prepare("
            INSERT INTO activities 
            (activity_type, content_id, ip_address, user_agent, country, details) 
            VALUES (?, ?, ?, ?, ?, ?)
        ");
        
        if (!$stmt) {
            throw new Exception("Prepare failed: " . $conn->error);
        }
        
        $stmt->bind_param("sissss", $type, $contentId, $ip, $userAgent, $country, $details);
        
        if (!$stmt->execute()) {
            throw new Exception("Execute failed: " . $stmt->error);
        }
        
        $stmt->close();
        
        // تحديث الإحصائيات اليومية
        $today = date('Y-m-d');
        $updateField = $type . 's'; // copies, searches, reports
        
        $updateStats = "
            INSERT INTO daily_stats (stat_date, $updateField) 
            VALUES ('$today', 1)
            ON DUPLICATE KEY UPDATE $updateField = $updateField + 1
        ";
        
        $conn->query($updateStats);
        
        return true;
        
    } catch (Exception $e) {
        error_log("Error tracking activity: " . $e->getMessage());
        return false;
    }
}

function calculatePercentageChange($current, $previous) {
    if ($previous == 0) return 0;
    return round((($current - $previous) / $previous) * 100, 1);
}

?>