<?php
require_once 'includes/config.php';
require_once 'includes/functions.php';

header('Content-Type: text/html; charset=utf-8');

// تتبع الزيارة
try {
    trackVisit();
} catch (Exception $e) {
    // تجاهل الأخطاء لعدم تعطيل الصفحة
    error_log("Visit tracking error: " . $e->getMessage());
}

// جلب أنواع المحتوى مع عدد العناصر في كل نوع
$types_query = "SELECT ct.*, COUNT(c.id) as content_count 
                FROM content_types ct 
                LEFT JOIN contents c ON ct.id = c.type_id AND c.status = 1 
                WHERE ct.status = 1 
                GROUP BY ct.id 
                HAVING content_count > 0";
$types = $conn->query($types_query);

// تخزين أنواع المحتوى في مصفوفة
$content_types = [];
while($type = $types->fetch_assoc()) {
    $content_types[$type['id']] = $type;
    
    // جلب المحتوى لكل نوع
    $contents_query = "SELECT c.* 
                      FROM contents c 
                      WHERE c.type_id = {$type['id']} 
                      AND c.status = 1 
                      ORDER BY c.id DESC";
    $content_types[$type['id']]['contents'] = $conn->query($contents_query);
}

// جلب الإحصائيات
$stats = [
    'contents' => $conn->query("SELECT COUNT(*) as count FROM contents WHERE status = 1")->fetch_assoc()['count'],
    'readers' => $conn->query("SELECT COUNT(*) as count FROM readers WHERE status = 1")->fetch_assoc()['count'],
    'commands' => $conn->query("SELECT COUNT(*) as count FROM content_readers WHERE status = 1")->fetch_assoc()['count']
];

// جلب أكثر القراء نشاطاً
$top_readers = $conn->query("
    SELECT r.name, COUNT(cr.id) as content_count 
    FROM readers r 
    JOIN content_readers cr ON r.id = cr.reader_id 
    WHERE r.status = 1 
    GROUP BY r.id 
    ORDER BY content_count DESC 
    LIMIT 3
");

// جلب آخر الإضافات
$recent_content = $conn->query("
    SELECT c.title, ct.name as type_name 
    FROM contents c 
    JOIN content_types ct ON c.type_id = ct.id 
    WHERE c.status = 1 
    ORDER BY c.created_at DESC 
    LIMIT 3
");
?>

<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>دليل المستخدم - <?php echo SITE_NAME; ?></title>
    
    <!-- CSS Files -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200;300;400;600;700;900&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
    
    <style>
    :root {
        --primary: #023047;
        --secondary: #219ebc;
        --accent: #fb8500;
        --accent-light: #ffb703;
        --light-blue: #8ecae6;
        --border-color: #dee2e6;
    }

    body {
        font-family: 'Cairo', sans-serif;
        background-color: #f8f9fa;
    }

    /* Important Links Styles */
    .important-links {
        background: var(--primary);
        border-bottom: 1px solid rgba(255,255,255,0.1);
        padding: 10px 0;
    }

    .important-links .btn {
        transition: all 0.3s ease;
    }

    .important-links .btn:hover {
        transform: translateY(-2px);
    }

    /* Hero Section Styles */
    .hero-section {
        background: linear-gradient(135deg, var(--primary), var(--secondary));
        padding: 60px 0;
        margin-bottom: 30px;
        position: relative;
        overflow: hidden;
    }

    .hero-section::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(45deg, rgba(0,0,0,0.1) 25%, transparent 25%),
                    linear-gradient(-45deg, rgba(0,0,0,0.1) 25%, transparent 25%);
        background-size: 60px 60px;
    }

    /* Stats Cards Styles */
    .stats-card {
        background: rgba(255,255,255,0.1);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255,255,255,0.2);
        border-radius: 15px;
        padding: 25px;
        text-align: center;
        transition: transform 0.3s ease;
        height: 100%;
    }

    .stats-card:hover {
        transform: translateY(-5px);
    }

    .stats-card i {
        font-size: 2rem;
        color: var(--accent-light);
        margin-bottom: 15px;
    }

    .stats-card h3 {
        color: white;
        font-size: 2rem;
        margin-bottom: 5px;
        font-weight: 700;
    }

    .stats-card p {
        color: rgba(255,255,255,0.9);
        margin: 0;
    }

    /* Search and Filter Styles */
    .search-container {
        position: sticky;
        top: 0;
        z-index: 1000;
        background: white;
        padding: 15px 0;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }

    .filter-tabs {
        display: flex;
        gap: 10px;
        margin: 20px 0;
        overflow-x: auto;
        padding-bottom: 5px;
    }

    .filter-tab {
        padding: 8px 20px;
        border-radius: 20px;
        background: white;
        border: 1px solid var(--border-color);
        cursor: pointer;
        white-space: nowrap;
        transition: all 0.3s ease;
    }

    .filter-tab.active {
        background: var(--accent);
        color: white;
        border-color: var(--accent);
    }

    /* Content Grid Styles */
    .content-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
        gap: 20px;
        padding: 20px 0;
    }

    .content-card {
        background: white;
        border-radius: 15px;
        overflow: hidden;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        transition: transform 0.3s ease;
        animation: fadeIn 0.5s ease forwards;
    }

    .content-card:hover {
        transform: translateY(-5px);
    }

    .content-header {
        background: var(--primary);
        color: white;
        padding: 15px;
        position: relative;
    }

    .content-type-badge {
        position: absolute;
        top: 15px;
        left: 15px;
        background: var(--accent);
        padding: 5px 10px;
        border-radius: 15px;
        font-size: 0.8rem;
    }

    /* Commands Styles */
    .content-commands {
        padding: 15px;
    }

    .command-box {
        background: white;
        border: 1px solid var(--border-color);
        border-radius: 8px;
        padding: 8px 12px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 5px;
    }

    .command-text {
        font-size: 0.9rem;
        color: var(--primary);
    }

    .copy-btn {
        background: none;
        border: none;
        color: var(--accent);
        cursor: pointer;
        padding: 5px;
        border-radius: 4px;
        transition: all 0.3s ease;
    }

    .copy-btn:hover {
        background: rgba(251,133,0,0.1);
    }

    /* Readers List Styles */
    .readers-commands {
        max-height: 200px;
        overflow-y: auto;
        padding-right: 5px;
    }

    .readers-commands::-webkit-scrollbar {
        width: 6px;
    }

    .readers-commands::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 10px;
    }

    .readers-commands::-webkit-scrollbar-thumb {
        background: var(--accent);
        border-radius: 10px;
    }

    .readers-commands::-webkit-scrollbar-thumb:hover {
        background: var(--primary);
    }

    .readers-commands .command-box {
        margin-bottom: 8px;
        border: 1px solid var(--border-color);
        transition: all 0.2s ease;
    }

    .readers-commands .command-box:hover {
        border-color: var(--accent);
        background-color: rgba(251,133,0,0.02);
    }

    .reader-name {
        font-size: 0.85rem;
        color: var(--primary);
        font-weight: 600;
        margin-bottom: 4px;
    }

    .readers-commands .command-text {
        font-size: 0.9rem;
        line-height: 1.4;
    }

    .readers-commands {
        position: relative;
    }

    .readers-commands::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 20px;
        background: linear-gradient(to top, white, transparent);
        pointer-events: none;
        opacity: 0;
        transition: opacity 0.2s ease;
    }

    .readers-commands:hover::after {
        opacity: 1;
    }

    /* Mobile Menu Styles */
    .mobile-menu-toggle {
        position: fixed;
        bottom: 20px;
        right: 20px;
        z-index: 1030;
    }

    .menu-btn {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        background: var(--primary);
        border: none;
        color: white;
        box-shadow: 0 2px 10px rgba(0,0,0,0.2);
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.2rem;
        transition: all 0.3s ease;
    }

    .menu-btn:hover {
        transform: scale(1.1);
    }

/*Report Model CSS*/

/* Report Styles */
.report-section {
    border-top: 1px solid var(--border-color);
    padding-top: 15px;
}

.report-section .btn-outline-danger {
    color: #dc3545;
    border-color: #dc3545;
    transition: all 0.3s ease;
}

.report-section .btn-outline-danger:hover {
    color: #fff;
    background-color: #dc3545;
    border-color: #dc3545;
}

/* Modal Styles */
#reportModal .modal-content {
    border-radius: 15px;
}

#reportModal .modal-header {
    background: #f8f9fa;
    border-radius: 15px 15px 0 0;
}

#reportModal .form-control,
#reportModal .form-select {
    border-radius: 8px;
}

#reportModal textarea {
    resize: none;
}

/* Loading State */
.btn-loading {
    position: relative;
    pointer-events: none;
    opacity: 0.8;
}

.btn-loading .spinner-border {
    position: absolute;
    left: 50%;
    top: 50%;
    transform: translate(-50%, -50%);
}

.btn-loading span:not(.spinner-border) {
    visibility: hidden;
}

/* Icon Animation */
.report-section .btn-outline-danger i {
    transition: transform 0.3s ease;
}

.report-section .btn-outline-danger:hover i {
    transform: scale(1.1);
}

/*End Report Model CSS*/
    /* Animations */
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    /* Responsive Styles */
    @media (max-width: 768px) {
        .content-grid {
            grid-template-columns: 1fr;
        }

        .filter-tabs {
            padding-bottom: 10px;
        }

        .stats-card h3 {
            font-size: 1.5rem;
        }

        .important-links .btn {
            font-size: 0.8rem;
        }
    }
    </style>
</head>
<body>
    <!-- Important Links Section -->
    <section class="important-links d-none d-lg-block">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center flex-wrap gap-3">
                <div class="d-flex align-items-center gap-3">
                    <i class="fas fa-info-circle text-warning"></i>
                    <span class="text-white">روابط مهمة:</span>
                </div>
                <div class="d-flex flex-wrap gap-3">
                    <a href="#" class="btn btn-sm btn-outline-light" data-bs-toggle="modal" data-bs-target="#alexaGuideModal">
                        <i class="fab fa-amazon me-1"></i>
                        دليل تشغيل أليكسا
                    </a>
                    <a href="#" class="btn btn-sm btn-outline-light">
                        <i class="fas fa-question-circle me-1"></i>
                        الأسئلة الشائعة
                    </a>
                    <a href="#" class="btn btn-sm btn-outline-light">
                        <i class="fas fa-headphones me-1"></i>
                        تجربة الأوامر الصوتية
                    </a>
                    <a href="#" class="btn btn-sm btn-outline-warning">
                        <i class="fas fa-bug me-1"></i>
                        الإبلاغ عن مشكلة
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container text-white">
            <div class="row align-items-center mb-5">
                <div class="col-lg-6">
                    <h1 class="mb-4"><?php echo SITE_NAME; ?></h1>
                    <p class="lead">دليل استخدام مهارة أليكسا للأذان والزيارات والأدعية</p>
                </div>
                <div class="col-lg-6">
                    <div class="site-content p-4 rounded-3" style="background: rgba(255,255,255,0.1);">
                        <h5 class="mb-3">
                            <i class="fas fa-list-alt me-2"></i>
                            محتوى الموقع
                        </h5>
                        <ul class="list-unstyled mb-0">
                            <?php foreach($content_types as $type): 
                                $type_count = $conn->query("SELECT COUNT(*) as count FROM contents WHERE type_id = {$type['id']} AND status = 1")->fetch_assoc()['count'];
                            ?>
                            <li class="mb-2 d-flex justify-content-between align-items-center">
                                <span>
                                    <?php 
                                    $icon = getTypeIcon($type['name']);
                                    ?>
                                    <i class="fas <?php echo $icon; ?> me-2"></i>
                                    <?php echo $type['name']; ?>
                                </span>
                                <span class="badge bg-accent rounded-pill"><?php echo $type_count; ?></span>
                            </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Stats Cards -->
            <div class="row g-4">
                <div class="col-md-3">
                    <div class="stats-card">
                        <i class="fas fa-book-open"></i>
                        <h3><?php echo $stats['contents']; ?></h3>
                        <p>محتوى متنوع</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stats-card">
                        <i class="fas fa-users"></i>
                        <h3><?php echo $stats['readers']; ?></h3>
                        <p>قارئ مميز</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stats-card">
                        <i class="fas fa-microphone-alt"></i>
                        <h3><?php echo $stats['commands']; ?></h3>
                        <p>أمر صوتي</p>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stats-card">
                        <i class="fas fa-clock"></i>
                        <h3><?php 
                            $last_update = $conn->query("SELECT MAX(created_at) as last_update FROM contents")->fetch_assoc()['last_update'];
                            echo date('Y/m/d', strtotime($last_update));
                        ?></h3>
                        <p>آخر تحديث</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Search & Filter Section -->
    <div class="search-container">
        <div class="container">
            <div class="input-group">
                <span class="input-group-text">
                    <i class="fas fa-search"></i>
                </span>
                <input type="text" id="searchInput" class="form-control" 
                       placeholder="ابحث عن دعاء، قارئ، أذان أو زيارة...">
            </div>

            <div class="filter-tabs">
                <div class="filter-tab active" data-type="all">الكل</div>
                <?php foreach($content_types as $type): ?>
                    <div class="filter-tab" data-type="<?php echo $type['id']; ?>">
                        <i class="fas <?php echo getTypeIcon($type['name']); ?> me-1"></i>
                        <?php echo $type['name']; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <!-- Content Grid -->
    <div class="container">
        <div class="content-grid" id="contentGrid">
            <?php foreach($content_types as $type): 
                $contents = $type['contents'];
                while($content = $contents->fetch_assoc()):
                    $readers_query = "SELECT r.name, cr.command_phrase 
                                    FROM content_readers cr 
                                    JOIN readers r ON cr.reader_id = r.id 
                                    WHERE cr.content_id = {$content['id']} 
                                    AND cr.status = 1";
                    $readers = $conn->query($readers_query);
            ?>
            <div class="content-card" data-type="<?php echo $type['id']; ?>">
                <div class="content-header">
                    <h3 class="h5 mb-0"><?php echo $content['title']; ?></h3>
                    <span class="content-type-badge">
                        <i class="fas <?php echo getTypeIcon($type['name']); ?> me-1"></i>
                        <?php echo $type['name']; ?>
                    </span>
                </div>
                <div class="content-commands">
                    <!-- Default Command -->
                    <div class="default-command mb-3">
                        <label class="text-muted small mb-1">
                            <i class="fas fa-magic me-1"></i>
                            الأمر الافتراضي
                        </label>
                        <div class="command-box">
                            <span class="command-text">
                                اطلبي من صوتيات الشيعة تشغيل <?php echo $content['title']; ?>
                            </span>
                            <button class="copy-btn" 
                                    data-command="اطلبي من صوتيات الشيعة تشغيل <?php echo $content['title']; ?>">
                                <i class="fas fa-copy"></i>
                            </button>
                        </div>
                    </div>

                    <!-- Readers Commands -->
                    <div class="readers-commands">
                        <label class="text-muted small mb-2">
                            <i class="fas fa-users me-1"></i>
                            الأوامر حسب القراء
                        </label>
                        <?php while($reader = $readers->fetch_assoc()): ?>
                        <div class="command-box">
                            <div class="reader-name">
                                <i class="fas fa-user-circle me-1"></i>
                                <?php echo $reader['name']; ?>
                            </div>
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="command-text">
                                    <?php echo $reader['command_phrase']; ?>
                                </span>
                                <button class="copy-btn" 
                                        data-command="<?php echo $reader['command_phrase']; ?>">
                                    <i class="fas fa-copy"></i>
                                </button>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                    
                                    
                                        <!-- داخل content-card، قبل نهاية div.content-commands -->
<div class="report-section mt-3">
    <button class="btn btn-sm btn-outline-danger w-100" 
            onclick="showReportModal(<?php echo $content['id']; ?>, '<?php echo htmlspecialchars($content['title']); ?>')">
        <i class="fas fa-flag me-1"></i>
        الإبلاغ عن مشكلة
    </button>
</div>


                </div>
            </div>
            <?php 
                endwhile;
            endforeach; 
            ?>
        </div>

        <!-- No Results Message -->
        <div class="no-results text-center p-5 d-none">
            <img src="assets/images/no-results.svg" alt="لا توجد نتائج" class="mb-3" style="max-width: 200px;">
            <h3 class="h4 mb-2">لا توجد نتائج</h3>
            <p class="text-muted">جرب البحث بكلمات مختلفة</p>
        </div>
    </div>



    <!-- Report Modal -->
<!-- Report Modal -->
<div class="modal fade" id="reportModal" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-flag text-danger me-2"></i>
                    الإبلاغ عن مشكلة
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            <form id="reportForm">
                <div class="modal-body">
                    <input type="hidden" id="reportContentId" name="content_id">
                    
                    <div class="mb-3">
                        <label for="reportContentTitle" class="form-label">المحتوى</label>
                        <input type="text" id="reportContentTitle" class="form-control" readonly>
                    </div>

                    <div class="mb-3">
                        <label for="reporterName" class="form-label">الاسم</label>
                        <input type="text" id="reporterName" name="reporter_name" class="form-control" 
                               required minlength="3" maxlength="50">
                    </div>

                    <div class="mb-3">
                        <label for="reporterEmail" class="form-label">البريد الإلكتروني</label>
                        <input type="email" id="reporterEmail" name="reporter_email" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label for="issueType" class="form-label">نوع المشكلة</label>
                        <select id="issueType" name="issue_type" class="form-select" required>
                            <option value="">اختر نوع المشكلة</option>
                            <option value="not_working">المحتوى لا يعمل</option>
                            <option value="wrong_content">محتوى خاطئ</option>
                            <option value="bad_quality">جودة رديئة</option>
                            <option value="other">مشكلة أخرى</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">وصف المشكلة</label>
                        <textarea id="description" name="description" class="form-control" 
                                rows="4" required minlength="10" maxlength="500"></textarea>
                        <div class="form-text">يرجى وصف المشكلة بالتفصيل</div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                    <button type="submit" class="btn btn-danger" id="submitReportBtn">
                        <span class="spinner-border spinner-border-sm d-none me-2" role="status"></span>
                        <span>إرسال البلاغ</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- END Report Modal -->


    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // تهيئة أزرار النسخ
        document.querySelectorAll('.copy-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                const command = this.dataset.command;
                navigator.clipboard.writeText(command).then(() => {
                    const icon = this.querySelector('i');
                    icon.classList.remove('fa-copy');
                    icon.classList.add('fa-check');
                    
                    Swal.fire({
                        toast: true,
                        position: 'top-end',
                        icon: 'success',
                        title: 'تم نسخ الأمر بنجاح',
                        showConfirmButton: false,
                        timer: 1500
                    });

                    setTimeout(() => {
                        icon.classList.remove('fa-check');
                        icon.classList.add('fa-copy');
                    }, 1000);
                }).catch(err => {
                    Swal.fire({
                        toast: true,
                        position: 'top-end',
                        icon: 'error',
                        title: 'حدث خطأ أثناء النسخ',
                        showConfirmButton: false,
                        timer: 1500
                    });
                });
            });
        });

        // تهيئة البحث والفلترة
        const searchInput = document.getElementById('searchInput');
        const filterTabs = document.querySelectorAll('.filter-tab');
        const contentCards = document.querySelectorAll('.content-card');
        const noResults = document.querySelector('.no-results');
        let currentFilter = 'all';

        function filterContent() {
            const searchTerm = searchInput.value.toLowerCase();
            let hasResults = false;

            contentCards.forEach(card => {
                const type = card.dataset.type;
                const content = card.textContent.toLowerCase();
                const typeMatch = currentFilter === 'all' || type === currentFilter;
                const searchMatch = content.includes(searchTerm);

                if (typeMatch && searchMatch) {
                    card.style.display = 'block';
                    hasResults = true;
                } else {
                    card.style.display = 'none';
                }
            });

            noResults.classList.toggle('d-none', hasResults);
        }

        // إضافة مستمعي الأحداث
        searchInput.addEventListener('input', filterContent);

        filterTabs.forEach(tab => {
            tab.addEventListener('click', function() {
                filterTabs.forEach(t => t.classList.remove('active'));
                this.classList.add('active');
                currentFilter = this.dataset.type;
                filterContent();
            });
        });
    });
    
    // Report Model Script
    // دالة عرض نموذج البلاغ
function showReportModal(contentId, contentTitle) {
    document.getElementById('reportContentId').value = contentId;
    document.getElementById('reportContentTitle').value = contentTitle;
    const modal = new bootstrap.Modal(document.getElementById('reportModal'));
    modal.show();
}

        document.getElementById('reportForm').addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const form = this;
    const submitBtn = form.querySelector('button[type="submit"]');
    const spinner = submitBtn.querySelector('.spinner-border');
    const btnText = submitBtn.querySelector('span:not(.spinner-border)');
    
    try {
        // التحقق من صحة البيانات
        if (!form.checkValidity()) {
            form.classList.add('was-validated');
            return;
        }
        
        // تعطيل الزر وإظهار حالة التحميل
        submitBtn.disabled = true;
        spinner.classList.remove('d-none');
        btnText.textContent = 'جاري الإرسال...';
        
        const formData = new FormData(form);
        
        const response = await fetch('./api/submit_report.php', {
            method: 'POST',
            body: formData
        });
        
        // قراءة النص أولاً للتحقق
        const responseText = await response.text();
        console.log('Server Response:', responseText);
        
        let data;
        try {
            data = JSON.parse(responseText);
        } catch (error) {
            throw new Error('خطأ في معالجة استجابة الخادم');
        }
        
        if (data.success) {
            // إغلاق النموذج
            const modal = bootstrap.Modal.getInstance(document.getElementById('reportModal'));
            modal.hide();
            
            // إظهار رسالة النجاح
            Swal.fire({
                icon: 'success',
                title: 'تم إرسال البلاغ',
                text: 'شكراً لك! سيتم مراجعة البلاغ في أقرب وقت.',
                confirmButtonText: 'حسناً'
            });
            
            // إعادة تعيين النموذج
            form.reset();
            form.classList.remove('was-validated');
        } else {
            throw new Error(data.message || 'حدث خطأ أثناء إرسال البلاغ');
        }
        
    } catch (error) {
        console.error('Error:', error);
        Swal.fire({
            icon: 'error',
            title: 'خطأ',
            text: error.message,
            confirmButtonText: 'حسناً'
        });
    } finally {
        // إعادة تفعيل الزر وإخفاء حالة التحميل
        submitBtn.disabled = false;
        spinner.classList.add('d-none');
        btnText.textContent = 'إرسال البلاغ';
    }
});

// إعادة تعيين النموذج عند إغلاقه
document.getElementById('reportModal').addEventListener('hidden.bs.modal', function () {
    const form = this.querySelector('form');
    form.reset();
    form.classList.remove('was-validated');
});

    //End Report Model Script
    
    // Status Code

document.querySelectorAll('.copy-btn').forEach(btn => {
    btn.addEventListener('click', function() {
        const command = this.dataset.command;
        const contentId = this.dataset.contentId; // تأكد من إضافة هذا الـ attribute في HTML

        // نسخ النص
        navigator.clipboard.writeText(command).then(() => {
            // تسجيل نشاط النسخ
            fetch('api/track_activity.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    type: 'copy',
                    content_id: contentId,
                    details: command
                })
            });

            // إظهار رسالة النجاح
            Swal.fire({
                toast: true,
                position: 'top-end',
                icon: 'success',
                title: 'تم نسخ الأمر بنجاح',
                showConfirmButton: false,
                timer: 1500
            });
        });
    });
});

    // End Status Code 
    </script>

    <?php
    function getTypeIcon($typeName) {
        switch(strtolower($typeName)) {
            case 'أذان': return 'fa-mosque';
            case 'دعاء': return 'fa-pray';
            case 'زيارة': return 'fa-kaaba';
            default: return 'fa-book';
        }
    }
    ?>
    

</body>
</html>